package com.liquidnet.service.galaxy.router.xuper.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryRespDto;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyPublish;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterPublishHandler;
import com.liquidnet.service.galaxy.router.xuper.biz.XuperPublishBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyXuperPublishImpl
 * @Package com.liquidnet.service.galaxy.router.xuper.service
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:03
 */
@Slf4j
@Component
@StrategyGalaxyRouterPublishHandler(GalaxyEnum.RouterTypeEnum.XUPER)
public class GalaxyRouterStrategyXuperPublishImpl implements IGalaxyRouterStrategyPublish {
    @Autowired
    private XuperPublishBiz xuperPublishBiz;

    @Override
    public ResponseDto<GalaxyNftPublishRespDto> nftPublish(GalaxyNftPublishReqDto reqDto) {
        return xuperPublishBiz.nftPublish(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftPublishResultQueryRespDto> nftPublishResultQuery(GalaxyNftPublishResultQueryReqDto reqDto) {
        return xuperPublishBiz.nftPublishResultQuery(reqDto);
    }
}
