package com.liquidnet.service.merchant.util;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderListVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

@Component
public class MongoMerchantUtils {
    @Autowired
    private RedisMerchantUtils redisMerchantUtils;
    @Autowired
    private MongoTemplate mongoTemplate;


    public PerformancePartnerVo getPerformancePartnerVo(String performanceId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)), PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
    }

    public long getPerformancePartnerCount(Query query) {
        return mongoTemplate.count(query, PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
    }

    public List<PerformancePartnerVo> getPerformancePartnerList(Query query) {
        return mongoTemplate.find(query, PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
    }

    public PerformancePartnerVo insertPerformancePartnerVo(PerformancePartnerVo data) {
        return mongoTemplate.insert(data, PerformancePartnerVo.class.getSimpleName());
    }

    public KylinTicketTimesPartnerVo insertTicketTimesPartnerVo(KylinTicketTimesPartnerVo data) {
        return mongoTemplate.insert(data, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public KylinTicketTimesPartnerVo getTicketTimesPartnerVo(String ticketTimesId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("ticketTimesId").is(ticketTimesId)), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public List<KylinTicketTimesPartnerVo> getTicketTimesPartnerVoList(String performancesId) {
        return mongoTemplate.find(Query.query(Criteria.where("performancesId").is(performancesId)), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public Object updateTicketTimesPartnerVo(KylinTicketTimesPartnerVo data) {
        Query query = Query.query(Criteria.where("ticketTimesId").is(data.getTicketTimesId()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(data)));
        UpdateResult result = mongoTemplate.updateFirst(query, update, KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
        return result;
    }

    public Object delTicketTimesPartnerVo(String ticketTimesId) {
        return mongoTemplate.remove(Query.query(Criteria.where("ticketTimesId").is(ticketTimesId)), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public KylinTicketPartnerVo insertTicketPartnerVo(KylinTicketPartnerVo data) {
        return mongoTemplate.insert(data, KylinTicketPartnerVo.class.getSimpleName());
    }

    public Object updateTicketPartnerVo(KylinTicketPartnerVo data) {
        Query query = Query.query(Criteria.where("ticketsId").is(data.getTicketsId()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(data)));
        UpdateResult result = mongoTemplate.updateFirst(query, update, KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
        return result;
    }

    public Object submitTicketByTimes(KylinTicketPartnerVo data) {
        Query query = Query.query(Criteria.where("timesId").is(data.getTimesId()).and("status").nin(-2, 7));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(data)));
        UpdateResult result = mongoTemplate.updateFirst(query, update, KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
        return result;
    }

    public long getCountTicketPartnerByTimes(String timesId) {
        return mongoTemplate.count((Query.query(Criteria.where("timesId").is(timesId))), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public List<KylinTicketPartnerVo> getTicketMongoList(String timesId) {
        return mongoTemplate.find(Query.query(Criteria.where("timesId").is(timesId).and("status").ne(-1))
                        .with(Sort.by(Sort.Direction.ASC, "createdAt")),
                KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public KylinTicketPartnerVo getTicketsMongo(String ticketsId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("ticketsId").is(ticketsId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public KylinTicketPartnerVo getTicketPartnerVo(String ticketsId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("ticketsId").is(ticketsId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public List<KylinTicketPartnerVo> getTicketPartnerVoList(String timesId) {
        return mongoTemplate.find(Query.query(Criteria.where("timesId").is(timesId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public Object updatePerformancePartnerVoById(PerformancePartnerVo data) {
        Query query = Query.query(Criteria.where("performancesId").is(data.getPerformancesId()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(data)));
        UpdateResult result = mongoTemplate.updateFirst(query, update, PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
        return result;
    }

    public Object updateSubmitTicketVoById(KylinTicketPartnerVo data) {
        Query query = Query.query(Criteria.where("ticketsId").is(data.getTicketsId()).and("status").in(3, 6, 8, 9, 10));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(data)));
        UpdateResult result = mongoTemplate.updateFirst(query, update, KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
        return result;
    }

    public void deleteTicketPartnerVo(String ticketsId) {
        mongoTemplate.remove(Query.query(Criteria.where("ticketsId").is(ticketsId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public boolean isExistsSubmitPerformancePartner(String performanceId) {
        return mongoTemplate.exists(Query.query(Criteria.where("performancesId").is(performanceId).and("auditStatus").is(0)),
                PerformancePartnerVo.class,
                PerformancePartnerVo.class.getSimpleName());
    }

    public boolean isExistsAddTicket(String timesId) {
        return mongoTemplate.exists(Query.query(Criteria.where("status").is(-2).and("timesId").is(timesId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public boolean isExistsAddTime(String performanceId) {
        return mongoTemplate.exists(Query.query(Criteria.where("status").is(-1).and("performancesId").is(performanceId)), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public List<KylinTicketTimesPartnerVo> getTimesMongoList(String performanceId) {
        return mongoTemplate.find(Query.query(Criteria.where("performancesId").is(performanceId)).with(Sort.by(Sort.Direction.ASC, "createdAt")),
                KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public KylinTicketTimesPartnerVo getTimesMongo(String timesId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("ticketTimesId").is(timesId).and("status")), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public KylinPerformanceVo insertPerformanceVo(KylinPerformanceVo data) {
        return mongoTemplate.insert(data, KylinPerformanceVo.class.getSimpleName());
    }

    public Object delPerformanceVo(String performanceId) {
        return mongoTemplate.remove(Query.query(Criteria.where("performancesId").is(performanceId)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
    }

    public KylinPerformanceVo getPerformanceVo(String performanceId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
    }

    public List<KylinPerformanceVo> getPerformanceVoOnlineList() {
        return mongoTemplate.find(Query.query(Criteria.where("appStatus").in(6, 8, 9)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
    }

}
