package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.sweet.task.FeignSweetWechatClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * sweet
 */
@Component
public class SweetWechatTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(SweetWechatTaskHandler.class);

    @Autowired
    private FeignSweetWechatClient feignSweetWechatClient;

    @XxlJob(value = "sev-sweet:sendMsg")
    public ReturnT<String> sendWechatMsgHandler() {
        try {
            feignSweetWechatClient.send().getData();
            log.info("sendWechatMsgHandler：结果：success");
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            return ReturnT.FAIL;
        }
    }

}
