package com.liquidnet.service.merchant.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "MerchantSponsorsVo", description = "主办")
@Data
public class MerchantSponsorsVo implements java.io.Serializable{
    private static final long serialVersionUID = -5422950992644764083L;

    @ApiModelProperty(position = 11, value = "主办ID")
    private String sponsorId;
    @ApiModelProperty(position = 12, value = "上线状态 0下线 1上线")
    private Integer isOnline;
    @ApiModelProperty(position = 13, value = "主办所有者账号")
    private String uid;

    @ApiModelProperty(position = 14, value = "主办名称[30]")
    private String name;
    @ApiModelProperty(position = 15, value = "logo图")
    private String logo;
    @ApiModelProperty(position = 16, value = "背景图")
    private String background;
    @ApiModelProperty(position = 17, value = "介绍[1000]")
    private String description;

    @ApiModelProperty(position = 18, value = "联系人姓名")
    private String contactName;
    @ApiModelProperty(position = 19, value = "联系人身份证号码")
    private String contactIdentity;
    @ApiModelProperty(position = 20, value = "联系人身份证正面照")
    private String contactIdentityObverse;
    @ApiModelProperty(position = 21, value = "联系人身份证反面照")
    private String contactIdentityReverse;
    @ApiModelProperty(position = 22, value = "联系人邮箱")
    private String contactEmail;

    @ApiModelProperty(position = 23, value = "企业ID")
    private String companyId;
    @ApiModelProperty(position = 24, value = "企业")
    private MerchantCompaniesVo companiesVo;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
}
