package com.liquidnet.client.admin.web.controller.zhengzai.goblin;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.goblin.service.impl.GoblinFrontSeckillServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.goblin.entity.GoblinFrontSeckill;
import com.liquidnet.service.goblin.entity.GoblinSelfMarketing;
import com.liquidnet.service.goblin.entity.GoblinStoreMarketing;
import com.liquidnet.service.goblin.mapper.GoblinSelfMarketingMapper;
import com.liquidnet.service.goblin.mapper.GoblinStoreMarketingMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 秒杀表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-29
 */
@Api(tags = "秒杀管理")
@RestController
@RequestMapping("/seckill")
public class GoblinFrontSeckillController extends BaseController {
    @Autowired
    GoblinStoreMarketingMapper goblinStoreMarketingMapper;
    @Autowired
    GoblinSelfMarketingMapper goblinSelfMarketingMapper;
    @Autowired
    GoblinFrontSeckillServiceImpl goblinFrontSeckillService;

    /**
     * @author zhangfuxin
     * @Description:活动列表
     * @date 2021/12/29 下午2:51
     */
    @PostMapping("listActivity")
    @ApiOperation(value = "活动列表")
    @ResponseBody
    public AjaxResult listActivity() {
        //goblin_store_marketing
        LambdaQueryWrapper<GoblinStoreMarketing> queryWrapper = Wrappers.lambdaQuery(GoblinStoreMarketing.class);
        queryWrapper.ne(GoblinStoreMarketing::getStatus, 7);
        List<GoblinStoreMarketing> listStoreMarketing= goblinStoreMarketingMapper.selectList(queryWrapper);
        //goblin_self_marketing
        LambdaQueryWrapper<GoblinSelfMarketing> queryWrapperM = Wrappers.lambdaQuery(GoblinSelfMarketing.class);
        queryWrapperM.ne(GoblinSelfMarketing::getStatus,7);
        List<GoblinSelfMarketing> listGoblinSelfMarketing=goblinSelfMarketingMapper.selectList(queryWrapperM);
        //整合
        HashMap<String, Object> list= CollectionUtil.mapStringObject();
        list.put("listStoreMarketing",listStoreMarketing);
        list.put("listGoblinSelfMarketing",listGoblinSelfMarketing);
        return  AjaxResult.success(list);
    }

    /**
     * @author zhangfuxin
     * @Description:限时秒杀添加
     * @date 2021/12/29 下午2:51
     */
    @PostMapping("create")
    @ApiOperation(value = "增加秒杀")
    @ResponseBody
    public AjaxResult create( @RequestBody GoblinFrontSeckill goblinFrontSeckill) {
        logger.info("增加秒杀{}", JSON.toJSONString(goblinFrontSeckill));
        boolean result=goblinFrontSeckillService.create(goblinFrontSeckill);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    /**
     * @author zhangfuxin
     * @Description:限时秒杀修改
     * @date 2021/12/29 下午2:52
     */

    @PostMapping("update")
    @ApiOperation(value = "限时秒杀修改")
    @ResponseBody
    public AjaxResult update( @RequestBody GoblinFrontSeckill goblinFrontSeckill) {
        logger.info("限时秒杀修改{}", JSON.toJSONString(goblinFrontSeckill));
        boolean result=goblinFrontSeckillService.update(goblinFrontSeckill);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    /***
     * @author zhangfuxin
     * @Description:限时秒杀删除
     * @date 2021/12/29 下午2:52
     */
    @PostMapping("delete")
    @ApiOperation(value = "限时秒杀删除")
    @ResponseBody
    public AjaxResult delete( @RequestBody GoblinFrontSeckill goblinFrontSeckill) {
        logger.info("限时秒杀删除{}", JSON.toJSONString(goblinFrontSeckill));
        boolean result=goblinFrontSeckillService.delte(goblinFrontSeckill.getMid());
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    
    /**
     * @author zhangfuxin
     * @Description:限时秒杀分页
     * @date 2021/12/29 下午2:52
     */
    @PostMapping("page")
    @ApiOperation(value = "分页")
    @ResponseBody
    public AjaxResult page( @RequestParam(name = "pageSize", required = true) int pageSize,@RequestParam(name = "pageNumber", required = true)int pageNumber,@RequestBody GoblinFrontSeckill goblinFrontSeckill) {
        logger.info("限时秒杀分页{}", JSON.toJSONString(goblinFrontSeckill));
        return AjaxResult.success(goblinFrontSeckillService.page(pageSize,pageNumber,null));
    }

    /**
     * @author zhangfuxin
     * @Description:限时秒杀详情
     * @date 2021/12/29 下午2:54
     */
    @PostMapping("getOne")
    @ApiOperation(value = "查看详情")
    @ResponseBody
    public AjaxResult getOne( @RequestBody GoblinFrontSeckill goblinFrontSeckill) {
        logger.info("查看详情{}", JSON.toJSONString(goblinFrontSeckill));
        GoblinFrontSeckill goblinFrontSeckill1=goblinFrontSeckillService.getOne(goblinFrontSeckill.getMid());
        return AjaxResult.success(goblinFrontSeckill1);
    }
}
