package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "GoblinStoreMgtGoodsSkuArAddParam", description = "商品管理:藏品AR:新增入参")
@Data
public class GoblinStoreMgtGoodsSkuArAddParam implements Serializable {
    private static final long serialVersionUID = -6002785025793722474L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID")
    @NotNull(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "单品ID")
    @NotNull(message = "单品ID不能为空")
    private String skuId;
    @ApiModelProperty(position = 12, required = true, value = "单品AR文件URL-iOS版[256]")
    @NotNull(message = "iOS文件不能为空")
    private String arUrlIos;
    @ApiModelProperty(position = 13, required = true, value = "单品AR文件URL-android版[256]")
    @NotNull(message = "android文件不能为空")
    private String arUrlAndroid;
}
