package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.service.consumer.kylin.receiver.ConsumerCandyCouponBackRdsReceiver;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerCandyCouponOrderBackRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.CandyQueue.COUPON_BACK;
import static com.liquidnet.service.base.constant.MQConst.CandyQueue.COUPON_ORDER_BACK;


@Configuration
public class ConsumerCandyCouponOrderBackRedisStreamConfig {
    @Autowired
    ConsumerCandyCouponOrderBackRdsReceiver consumerCandyCouponOrderBackRdsReceiver;

    private StreamMessageListenerContainer<String, MapRecord<String, String, String>> buildStreamMessageListenerContainer(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        return StreamMessageListenerContainer.create(factory, options);
    }

    /**
     * 缺票登记
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveSqlCandyCouponBack(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(COUPON_ORDER_BACK.getGroup(), COUPON_ORDER_BACK.name() + t),
                StreamOffset.create(COUPON_ORDER_BACK.getKey(), ReadOffset.lastConsumed()), consumerCandyCouponOrderBackRdsReceiver
        );
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 缺票登记 */

    @Bean
    public Subscription subscriptionSqlCandyCouponOrderBack(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCandyCouponBack(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCandyCouponOrderBack2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCandyCouponBack(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCandyCouponOrderBack3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCandyCouponBack(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
