package com.liquidnet.service.kylin.controller.partner;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.PerformancePartnerListDao;
import com.liquidnet.service.kylin.dto.param.*;
import com.liquidnet.service.kylin.service.impl.partner.KylinPerformancesPartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.HashMap;
import java.util.Map;

@Api(tags = "第三方-演出")
@RestController
@RequestMapping("partner/performance")
public class PerformancePartnerController {

    @Autowired
    private KylinPerformancesPartnerServiceImpl performancesPartnerService;

    @PostMapping(value = "list")
    @ApiOperation(value = "演出列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<PerformancePartnerListDao>> getList(@RequestBody @Valid PerformancePartnerListParam performancePartnerListParam) {
        return performancesPartnerService.getList(performancePartnerListParam);
    }

    @PostMapping(value = "copy")
    @ApiOperation(value = "复制演出")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Map<String, String>> copyPerformance(@RequestParam("performancesId") String performancesId) {
        String result = performancesPartnerService.copyPerformance(performancesId);
        if (null == result) {
            return ResponseDto.failure("复制失败");
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("performancesId", result);
            return ResponseDto.success(map);
        }
    }


    @GetMapping(value = "step1")
    @ApiOperation(value = "获取演出第一步数据")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformancePartnerVo> getStep1(@RequestParam("performancesId") String performancesId) {
        return performancesPartnerService.getStep1(performancesId);
    }

    @PostMapping(value = "step1")
    @ApiOperation(value = "操作演出第一步")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Map<String, String>> Step1(@RequestBody @Valid PerformanceStep1Param performanceStep1Param) {
        String result = performancesPartnerService.step1(performanceStep1Param);
        if (result.isEmpty()) {
            return ResponseDto.failure("操作失败");
        } else if (result.equals("不可修改")) {
            return ResponseDto.failure(result);
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("performancesId", result);
            return ResponseDto.success(map);
        }
    }


    @PostMapping(value = "step2")
    @ApiOperation(value = "操作演出第二步")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> step2(@RequestBody @Valid PerformanceStep2Param performanceStep2Param) {
        return performancesPartnerService.step2(performanceStep2Param);
    }

    @GetMapping(value = "step2")
    @ApiOperation(value = "获取演出第二步数据")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformanceStep2Param> getStep2(@RequestParam("performancesId") String performancesId) {
        return performancesPartnerService.getStep2(performancesId);
    }

    @PostMapping(value = "online")
    @ApiOperation(value = "演出上线")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> onLinePerformance(@RequestParam("performancesId") String performancesId) {
        return performancesPartnerService.onLinePerformance(performancesId);
    }

    @PostMapping(value = "outline")
    @ApiOperation(value = "演出下线")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> outLinePerformance(@RequestParam("performancesId") String performancesId) {
        return performancesPartnerService.outLinePerformance(performancesId);
    }

    @PostMapping(value = "withdraw")
    @ApiOperation(value = "演出撤回")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> withdraw(@RequestParam("performancesId") String performancesId) {
        return performancesPartnerService.withdraw(performancesId);
    }
}
