/**
 * $Id: PageControllerAdviceHandler.java 13332 2016-07-06 09:15:06Z anjiabin $
 * Copyright(C) 2014-2020 easegame, All Rights Reserved.
 */
package com.liquidnet.common.exception;

import com.liquidnet.common.exception.annotation.PageErrorController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: PageControllerAdviceHandler
 * @class: PageControllerAdviceHandler
 * @Package com.liquidnet.common.exception
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/21 10:37
 */
@ControllerAdvice(annotations = PageErrorController.class)
public class PageControllerAdviceHandler {
    private final Logger logger = LoggerFactory.getLogger(PageControllerAdviceHandler.class);

    @ExceptionHandler
    @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
    public String handleException(Model model, Exception exception) {
        logger.error("PageController errer:{}", exception);
        model.addAttribute("msg", exception.getMessage());
        if (exception instanceof LiquidnetServiceException) {
            LiquidnetServiceException ex = (LiquidnetServiceException) exception;
            logger.error("PageController errorCode:{}  errorMsg:{}", ex.errorCode(), ex.getMessage());
        }
        return "500";
    }
}
