package com.liquidnet.service.platform.service.impl.adam.sync.processor;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.service.adam.dto.AdamUserInfoDto;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.platform.service.impl.adam.sync.SyncDataProcessorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class SyncUserInformationProcessor extends SyncDataProcessorService {
    @Autowired
    AdamUserMapper userMapper;

    @Override
    public void dataProcessing(int stp) {
        Integer totalCount = userMapper.selectCount(Wrappers.lambdaQuery(AdamUser.class).eq(AdamUser::getState, 1));
        int totalRows = null == totalCount ? 0 : totalCount, nth = 0, offset = 5000, pct = 0;
        log.info("Sync.processing.begin:{} / {},{} ~ {}", totalCount, nth, offset, pct);



        while (totalRows > 0) {
            int rows = nth * offset;
            log.info("Sync.processing.limit {},{} - begin", rows, offset);



            List<AdamUserInfoDto> dtos = userMapper.selectMultiForUserInfoDto(rows, offset);
            if (!CollectionUtils.isEmpty(dtos)) {
                int size = dtos.size();
                for (int i = 0; i < size; i++) {
                    AdamUserInfoDto dto = dtos.get(i);

                    AdamUserInfoVo vo = AdamUserInfoVo.getNew().copy(dto);
                    //log.info("vo:{}", JsonUtils.toJson(vo));

                    dmRdmService.setUidByMobile(dto.getMobile(), dto.getUid());
                    dmRdmService.setUserInfoVoByUid(dto.getUid(), vo);

                    pct++;
                }
            }



            nth++;
            totalRows -= offset;
            log.info("Sync.processing.limit {},{} - handle.counts:{}", rows, offset, pct);
        }



        log.info("Sync.processing.end:{} / {},{} ~ {}", totalCount, nth, offset, pct);
    }
}
