package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.wallet.dto.base.WalletCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * WalletTransactionQueryParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/5
 */
@ApiModel(value = "WalletTransactionQueryParam", description = "Parameters of wallet transaction query")
public class WalletTransactionQueryParam extends WalletCallParam {
    private static final long serialVersionUID = -8387158390306087305L;
    @ApiModelProperty(position = 11, required = true, value = "Wallet number [11]")
    private String walletNo;
    @ApiModelProperty(position = 11, value = "Type of `strList` default:0 [0:transNo,1:tracingNo]", example = "0")
    private String strListType;
    @ApiModelProperty(position = 13, required = true, value = "Wallet transaction number [List<String>]")
    private List<String> strList;

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public String getStrListType() {
        return strListType;
    }

    public void setStrListType(String strListType) {
        this.strListType = strListType;
    }

    public List<String> getStrList() {
        return strList;
    }

    public void setStrList(List<String> strList) {
        this.strList = strList;
    }
}
