package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinCommonService;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinStoreInfoService;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.goblin.dto.GoblinStoreSearchDto;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.entity.GoblinStoreInfo;
import com.liquidnet.service.goblin.mapper.GoblinStoreInfoMapper;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 店铺基础信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Slf4j
@Service
public class GoblinCommonServiceImpl implements IGoblinCommonService {

    @Autowired
    GoblinStoreInfoMapper goblinStoreInfoMapper;

    @Override
    public List<GoblinStoreSearchDto> storeSearch(String name, List<String> status) {
        List<GoblinStoreInfo> list = goblinStoreInfoMapper.selectList(Wrappers.lambdaQuery(GoblinStoreInfo.class)
                .like(GoblinStoreInfo::getStoreName, name)
                .in(GoblinStoreInfo::getStatus, status)
                .select(GoblinStoreInfo::getStoreId, GoblinStoreInfo::getStoreName, GoblinStoreInfo::getStatus));
        List<GoblinStoreSearchDto> dtoList = new ArrayList<>();
        for (GoblinStoreInfo item:list) {
            GoblinStoreSearchDto dto = GoblinStoreSearchDto.getNew();
            dto.setStatus(item.getStatus());
            dto.setStoreId(item.getStoreId());
            dto.setStoreName(item.getStoreName());
            dtoList.add(dto);
        }
        return dtoList;
    }
}
