package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 退款回掉参数
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-31 11:19 上午
 */

@ApiModel(value = "GoblinNftOrderRefundCallbackParam", description = "退款回调所需参数")
@Data
public class GoblinNftOrderRefundCallbackParam implements Serializable {

    @ApiModelProperty(value = "状态 1成功 0失败")
    private Integer status;

    @ApiModelProperty(value = "退款金额")
    private BigDecimal refundPrice;

    @ApiModelProperty(value = "PAY")
    private String refundCode;

    @ApiModelProperty(value = "业务方自己生成的退款标识 比如订单ID加000")
    private String orderRefundCode;

    @ApiModelProperty(value = "refundId")
    private String refundId;

    @ApiModelProperty(value = "refundType")
    private String refundType;

    @ApiModelProperty(value = "退款时间")
    private String refundAt;

    @ApiModelProperty(value = "退款失败错误信息")
    private String refundError;

}
