package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinNftPayResultVo", description = "下单唤起支付参数信息")
@Data
public class GoblinNftPayResultVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(position = 14, value = "状态")
    private Integer status;

    @ApiModelProperty(position = 15, value = "订单ID")
    private String orderId;

    @ApiModelProperty(position = 11, value = "code")
    private String code;

    @ApiModelProperty(position = 12, value = "orderCode")
    private String orderCode;

    @ApiModelProperty(position = 19, value = "金额")
    private BigDecimal price;

    @ApiModelProperty(position = 16, value = "支付类型")
    private String payType;

    @ApiModelProperty(position = 17, value = "showUrl")
    private String showUrl;

    @ApiModelProperty(position = 18, value = "returnUrl")
    private String returnUrl;

    @ApiModelProperty(position = 20, value = "payData")
    private Object payData;

    private static final GoblinNftPayResultVo obj = new GoblinNftPayResultVo();

    public static GoblinNftPayResultVo getNew() {
        try {
            return (GoblinNftPayResultVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftPayResultVo();
        }
    }

}
