package com.liquidnet.service.goblin.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class GoblinRedisUtils {
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;


    /* ---------------------------------------- sku库存相关 ---------------------------------------- */
    public void setSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        redisUtil.set(rk, stock);
    }

    public int getSkuStock(String marketPre, String skuId) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        Object obj = redisUtil.get(rk);
        if (obj == null) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    public int incrSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        return (int) redisUtil.incr(rk, stock);
    }

    public int decrSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        return (int) redisUtil.decr(rk, stock);
    }

    /* ---------------------------------------- 店铺数据源 ---------------------------------------- */

    private boolean setStoreIdByUid(String uid, String storeId) {
        return redisUtil.set(GoblinRedisConst.TMP_UID_STORE.concat(uid), storeId);
    }

    public void delStoreIdByUid(String uid) {
        redisUtil.del(GoblinRedisConst.TMP_UID_STORE.concat(uid));
    }

    private String getStoreIdByUid(String uid) {
        return (String) redisUtil.get(GoblinRedisConst.TMP_UID_STORE.concat(uid));
    }

    public boolean setStoreInfoVo(GoblinStoreInfoVo vo) {
        this.setStoreIdByUid(vo.getUid(), vo.getStoreId());
        return redisUtil.set(GoblinRedisConst.BASIC_STORE.concat(vo.getStoreId()), vo);
    }

    public void delStoreInfoVo(String storeId) {
        redisUtil.del(GoblinRedisConst.BASIC_STORE.concat(storeId));
    }

    public GoblinStoreInfoVo getStoreInfoVo(String storeId) {
        String rk = GoblinRedisConst.BASIC_STORE.concat(storeId);
        GoblinStoreInfoVo vo = (GoblinStoreInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getStoreInfoVo(storeId))) {
            redisUtil.set(rk, vo);
        }
        return vo;
    }

    public GoblinStoreInfoVo getStoreInfoVoByUid(String uid) {
        String storeId = this.getStoreIdByUid(uid);
        return null == storeId ? goblinMongoUtils.getStoreInfoVoByUid(uid) : this.getStoreInfoVo(storeId);
    }

    /* ---------------------------------------- 商品数据源 ---------------------------------------- */

    public boolean setGoodsInfoVo(GoblinGoodsInfoVo vo) {
        return redisUtil.set(GoblinRedisConst.BASIC_GOODS.concat(vo.getSpuId()), vo);
    }

    public void delGoodsInfoVo(String spuId) {
        redisUtil.del(GoblinRedisConst.BASIC_GOODS.concat(spuId));
    }

    /**
     * 商品基础信息
     *
     * @param spuId 商品ID
     * @return GoblinGoodsInfoVo
     */
    public GoblinGoodsInfoVo getGoodsInfoVo(String spuId) {
        String rk = GoblinRedisConst.BASIC_GOODS.concat(spuId);
        GoblinGoodsInfoVo vo = (GoblinGoodsInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getGoodsInfoVo(spuId))) {
            redisUtil.set(rk, vo);
        }
        return vo;
    }

    public boolean setGoodsSkuInfoVo(GoblinGoodsSkuInfoVo vo) {
        return redisUtil.set(GoblinRedisConst.BASIC_GOODS_SKU.concat(vo.getSkuId()), vo);
    }

    public void delGoodsSkuInfoVo(String skuId) {
        redisUtil.del(GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId));
    }

    /**
     * 单品信息
     *
     * @param skuId 单品ID
     * @return GoblinGoodsSkuInfoVo
     */
    public GoblinGoodsSkuInfoVo getGoodsSkuInfoVo(String skuId) {
        String rk = GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId);
        GoblinGoodsSkuInfoVo vo = (GoblinGoodsSkuInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getGoodsSkuInfoVo(skuId))) {
            redisUtil.set(rk, vo);
        }
        return vo;
    }


    /* ----------------------------------------  ---------------------------------------- */

    /**
     * 覆盖 商铺活动vo
     *
     * @param storeMarketId
     * @param storeId
     * @param vo
     * @return
     */
    public boolean setGoblinStoreMarketVo(String storeMarketId, String storeId, GoblinStoreMarketVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId).concat(":store_id:" + storeId);
        return redisUtil.set(redisKey, vo);
    }

    /**
     * 获取 商铺活动vo
     *
     * @param storeMarketId
     * @param storeId
     * @return
     */
    public GoblinStoreMarketVo getGoblinStoreMarketVo(String storeMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId).concat(":store_id:" + storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            GoblinStoreMarketVo vo = goblinMongoUtils.getStoreMarket(storeMarketId, storeId);
            setGoblinStoreMarketVo(storeMarketId, storeId, vo);
            return vo;
        } else {
            return (GoblinStoreMarketVo) obj;
        }
    }

    /**
     * 删除 商铺活动vo
     *
     * @param storeMarketId
     * @param storeId
     * @return
     */
    public void delGoblinStoreMarketVo(String storeMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId).concat(":store_id:" + storeId);
        redisUtil.del(redisKey);
    }


    /**
     * 获取 配置的商铺id
     *
     * @param marketId
     * @param storeId
     */
    public List<GoblinStoreMarketIsConfigVo> getStoreMarketIsConfig(String marketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return new ArrayList();
        } else {
            return (List<GoblinStoreMarketIsConfigVo>) obj;
        }
    }

    public void addStoreMarketIsConfig(String marketId, String storeId, String spuId, String marketSpuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        List<GoblinStoreMarketIsConfigVo> voList = getStoreMarketIsConfig(marketId, storeId);
        GoblinStoreMarketIsConfigVo vo = GoblinStoreMarketIsConfigVo.getNew();
        vo.setMarketSpuId(marketSpuId);
        vo.setSpuId(spuId);
        voList.add(vo);
        redisUtil.set(redisKey, voList);
    }

    public void delStoreMarketIsConfig(String marketId, String storeId, String spuId, String marketSpuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        List<GoblinStoreMarketIsConfigVo> voList = getStoreMarketIsConfig(marketId, storeId);
        for (int i = 0; i < voList.size(); i++) {
            String itemSpuId = voList.get(i).getSpuId();
            if (spuId.equals(itemSpuId)) {
                voList.remove(i);
            }
        }
        redisUtil.set(redisKey, voList);
    }

    /**
     * 添加 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     * @param vo
     */
    public void addMarketRelation(String marketPre, String marketId, GoblinMarketRelationVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        List<GoblinMarketRelationVo> voList = getMarketRelation(marketPre, marketId);
        voList.add(vo);
        redisUtil.set(redisKey, voList);
    }

    /**
     * 移除 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     */
    public void removeMarketRelation(String marketPre, String marketId, String spuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        List<GoblinMarketRelationVo> voList = getMarketRelation(marketPre, marketId);
        for (GoblinMarketRelationVo item : voList) {
            if (item.getSpuId().equals(spuId)) {
                voList.remove(item);
                break;
            }
        }
        redisUtil.set(redisKey, voList);
    }

    /**
     * 获取 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     */
    public List<GoblinMarketRelationVo> getMarketRelation(String marketPre, String marketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return new ArrayList();
        } else {
            return (List<GoblinMarketRelationVo>) obj;
        }
    }

    /**
     * 获取 当前商铺能参与的官方活动id列表
     *
     * @param storeId
     * @return
     */
    public List<String> getStoreZhengzaiRelation(String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_SELF_RELATION.concat(storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (List<String>) obj;
        }
    }

    /**
     * 正在下单 可参加商户关系 详情
     *
     * @param selfMarketId
     * @param storeId
     */
    public GoblinMarketingZhengzaiRelationVo getZhengzaiRelation(String selfMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_RELATION.concat(selfMarketId).concat(":store_id:" + storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinMarketingZhengzaiRelationVo) obj;
        }
    }

    /**
     * 正在下单 可参加商户 详情
     *
     * @param selfMarketId
     */
    public GoblinSelfMarketingVo getSelfMarket(String selfMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SELF_MARKET.concat(selfMarketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinSelfMarketingVo) obj;
        }
    }
}
