package com.liquidnet.service.kylin.dto.param.admin;

import com.liquidnet.service.kylin.entity.KylinExpressModule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * ExpressModuleFromParam
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-15
 */

@Data
@ApiModel(value = "ExpressModuleFromParam", description = "快递模版创建、编辑入参")
public class ExpressModuleFromParam implements Serializable, Cloneable {

    private static final long serialVersionUID = -5031042101093959654L;

    @ApiModelProperty(value = "快递模版id[创建不传] 编辑必须要传", example = "429803743878963206506461")
    private String moduleId;

    @ApiModelProperty(value = "快件产品名称", example = "标快")
    @NotBlank(message = "快件产品名称不能为空")
    private String title;

    @ApiModelProperty(value = "产品编码", example = "255")
    @NotNull(message = "产品编码不能为空")
    private Integer productCode;

    @ApiModelProperty(value = "时效类型", example = "T4")
    @NotBlank(message = "时效类型不能为空")
    private String agingType;

    @ApiModelProperty(value = "快递预估价格", example = "10")
    @NotNull(message = "快递预估价格不能为空mim")
    private BigDecimal estimatePriceMin;

    @ApiModelProperty(value = "快递预估价格", example = "30")
    @NotNull(message = "快递预估价格不能为空max")
    private BigDecimal estimatePriceMax;

    @ApiModelProperty(value = "支持的付款方式 多个逗号分割 1寄付 2到付", example = "1,2")
    @NotNull(message = "支持的付款方式不能为空")
    private String supportPayType;

    @ApiModelProperty(value = "是否上线 1未上线 2已上线", example = "429803743878963206506461")
    @NotNull(message = "是否上线不能为空") @Min(value = 1, message = "isOnline无效") @Max(value = 2, message = "isOnline无效")
    private Integer isOnline;

    private static final ExpressModuleFromParam obj = new ExpressModuleFromParam();

    public static ExpressModuleFromParam getNew() {
        try {
            return (ExpressModuleFromParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ExpressModuleFromParam();
        }
    }

    public KylinExpressModule copy(ExpressModuleFromParam source) {
        KylinExpressModule expressModule = KylinExpressModule.getNew();
        if (null == source) return null;
        expressModule.setTitle(source.getTitle());
        expressModule.setProductCode(source.getProductCode());
        expressModule.setAgingType(source.getAgingType());
        expressModule.setEstimatePriceMin(source.getEstimatePriceMin());
        expressModule.setEstimatePriceMax(source.getEstimatePriceMax());
        expressModule.setSupportPayType(source.getSupportPayType());
        expressModule.setIsOnline(source.getIsOnline());
        return expressModule;
    }

}