package com.liquidnet.service.kylin.dto.vo;

import com.liquidnet.service.kylin.entity.KylinExpressModule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <p>
 * 快递模版vo
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-15
 */

@Data
@ApiModel
public class KylinExpressModuleVo implements Serializable {

    private static final long serialVersionUID = 2171590423135769848L;

    @ApiModelProperty(value = "快递模版id")
    private String moduleId;

    @ApiModelProperty(value = "快件产品名称")
    private String title;

    @ApiModelProperty(value = "产品编码")
    private Integer productCode;

    @ApiModelProperty(value = "时效类型")
    private String agingType;

    @ApiModelProperty(value = "快递预估价格小")
    private BigDecimal estimatePriceMin;

    @ApiModelProperty(value = "快递预估价格大")
    private BigDecimal estimatePriceMax;

    @ApiModelProperty(value = "支持的付款方式 1寄付 2到付 多个逗号分割")
    private String supportPayType;

    @ApiModelProperty(value = "是否上线 1未上线 2已上线")
    private Integer isOnline;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

    private static final KylinExpressModuleVo obj = new KylinExpressModuleVo();

    public static KylinExpressModuleVo getNew() {
        try {
            return (KylinExpressModuleVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinExpressModuleVo();
        }
    }

    public KylinExpressModuleVo copy(KylinExpressModule source) {
        KylinExpressModuleVo expressModuleVo = KylinExpressModuleVo.getNew();
        if (null == source) return null;
        expressModuleVo.setModuleId(source.getModuleId());
        expressModuleVo.setTitle(source.getTitle());
        expressModuleVo.setProductCode(source.getProductCode());
        expressModuleVo.setAgingType(source.getAgingType());
        expressModuleVo.setEstimatePriceMin(source.getEstimatePriceMin());
        expressModuleVo.setEstimatePriceMax(source.getEstimatePriceMax());
        expressModuleVo.setSupportPayType(source.getSupportPayType());
        expressModuleVo.setIsOnline(source.getIsOnline());
        expressModuleVo.setCreatedAt(source.getCreatedAt());
        expressModuleVo.setUpdatedAt(source.getUpdatedAt());
        return expressModuleVo;
    }

}
