package com.liquidnet.service.goblin.constant;

public class GoblinStatusConst {
    /* ----------------------------------------------------------------- */
    public enum CommonStatus {
        COMMON_LIMIT_UN(0, "不限购"),
        COMMON_TYPE_ALL(0, "购买条件-全部用户"),
        COMMON_TYPE_MEMBER(1, "购买条件-会员用户"),
        COMMON_TYPE_CAN(2, "购买条件-指定用户"),
        ;
        private final int value;
        private final String desc;

        CommonStatus(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum Status {
        ORDER_STATUS_0(0, "待付款(用户刚下单)"),
        ORDER_STATUS_2(2, "代发货(用户付完款 等待商城发货)"),
        ORDER_STATUS_3(3, "代收货(商城已经发货 等待用户确认收货)"),
        ORDER_STATUS_4(4, "已完成(用户已经确认收货 订单结束)"),
        ORDER_STATUS_5(5, "取消订单(用户未付款前取消订单)"),
        ORDER_STATUS_6(6, "退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)"),
        ORDER_STATUS_7(7, "退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)"),
        ORDER_STATUS_61(61, "发起-退款(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)"),
        ORDER_STATUS_71(71, "发起-退货(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)"),

        ORDER_LOG_STATUS_11(11, "确认付款"),
        ORDER_LOG_STATUS_12(12, "修改金额"),
        ORDER_LOG_STATUS_13(13, "发货"),
        ORDER_LOG_STATUS_14(14, "取消订单"),
        ORDER_LOG_STATUS_15(15, "修改物流单号"),
        ORDER_LOG_STATUS_16(16, "核销虚拟商品订单"),
        ORDER_LOG_STATUS_17(17, "修改收货地址"),

        ORDER_LOG_STATUS_20(20, "商家发起退款"),
        ORDER_LOG_STATUS_201(201, "商家同意退款"),
        ORDER_LOG_STATUS_21(21, "退款申请"),
        ORDER_LOG_STATUS_22(22, "退款成功"),
        ORDER_LOG_STATUS_23(23, "退款拒绝"),
        ORDER_LOG_STATUS_24(24, "退货申请"),
        ORDER_LOG_STATUS_25(25, "退货拒绝"),
        ORDER_LOG_STATUS_26(26, "退货审核通过等待用户填写物流"),
        ORDER_LOG_STATUS_27(27, "待收货"),
        ORDER_LOG_STATUS_28(28, "退货完成"),
        ORDER_LOG_STATUS_29(29, "退款拒绝"),


        ORDER_BACK_STATUS_0(0, "商家发起退款(退款中)"),
        ORDER_BACK_STATUS_1(1, "退款申请(用户发送退款请求)"),
        ORDER_BACK_STATUS_2(2, "退款成功(商家同意退款)"),
        ORDER_BACK_STATUS_3(3, "退款拒绝(商家拒绝退款)"),
        ORDER_BACK_STATUS_4(4, "退货申请(用户发起退货请求)"),
        ORDER_BACK_STATUS_5(5, "退货拒绝(商家拒绝退货)"),
        ORDER_BACK_STATUS_6(6, "退货审核通过等待用户填写物流"),
        ORDER_BACK_STATUS_7(7, "待收货(退货中)"),
        ORDER_BACK_STATUS_8(8, "退货完成"),
        ORDER_BACK_STATUS_9(9, "退款拒绝"),
        ORDER_BACK_STATUS_10(10, "退款失败"),
        ORDER_BACK_STATUS_11(11, "取消退款"),
        ;

        private final int value;
        private final String desc;

        Status(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum Type {
        OPERATION_TYPE_1(1, "用户"),
        OPERATION_TYPE_2(2, "商家"),

        BACK_REASON_TYPE_1(1, "不想买了"),
        BACK_REASON_TYPE_2(2, "收货人信息有误"),
        BACK_REASON_TYPE_3(3, "未按指定时间发货"),
        BACK_REASON_TYPE_4(4, "其他"),
        BACK_REASON_TYPE_5(5, "不想买了"),
        BACK_REASON_TYPE_6(6, "商品质量问题"),
        BACK_REASON_TYPE_7(7, "收到商品与描述不符"),
        BACK_REASON_TYPE_8(8, "商铺发起"),
        BACK_REASON_TYPE_9(9, "系统自动申请"),
        BACK_REASON_TYPE_10(10, "超时支付自动退款"),

        BACK_TYPE_1(1, "退款"),
        BACK_TYPE_2(2, "退货"),
        ;

        private final int value;
        private final String desc;

        Type(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum MarketingStatus {
        SELF_TYPE_ZHENGZAI(1, "正在下单"),

        STORE_TYPE_PURCHASE(2, "限时秒杀"),

        STORE_PURCHASE_STATUS_ALL(-1, "全部"),
        STORE_PURCHASE_STATUS_UN_START(0, "等待开始"),
        STORE_PURCHASE_STATUS_ING_START(1, "活动中"),
        STORE_PURCHASE_STATUS_END_START(2, "活动结束"),
        STORE_PURCHASE_STATUS_STOP(7, "停用"),
        ;
        private final int value;
        private final String desc;

        MarketingStatus(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum MarketPreStatus {
        MARKET_PRE_ZHENGZAI("ZZ", "正在下单前缀"),
        MARKET_PRE_PURCHASE("PC", "限时秒杀前缀"),
        ;

        private final String value;
        private final String desc;

        MarketPreStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

        public static String getPre(String goblinId) {
            if (goblinId.contains(MARKET_PRE_ZHENGZAI.getValue())) {
                return MARKET_PRE_ZHENGZAI.getValue();
            } else if (goblinId.contains(MARKET_PRE_PURCHASE.getValue())) {
                return MARKET_PRE_PURCHASE.getValue();
            }
            return null;
        }
    }


    /* -----------------------------NFT订单状态------------------------------------ */
    public enum NftStatus {
        ORDER_STATUS_1(1, "待付款"),
        ORDER_STATUS_2(2, "已付款"),
        ORDER_STATUS_3(3, "已取消(未付款取消订单"),
        ORDER_STATUS_4(4, "退款中(目前只有超时支付)"),
        ORDER_STATUS_5(5, "已退款(目前只有超时支付)"),

        ORDER_REFUND_STATUS_1(1, "申请"),
        ORDER_REFUND_STATUS_2(2, "退款成功"),
        ORDER_REFUND_STATUS_3(3, "退款失败"),

        ORDER_TYPE_1(1, "购买订单"),
        ORDER_TYPE_2(2, "兑换订单"),
        ORDER_TYPE_3(3, "演出赠送订单"),
        ORDER_TYPE_4(4, "空投订单"),

        ;

        private final int value;
        private final String desc;

        NftStatus(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 数字藏品：转赠状态[PENDING|SUCCESS]
     */
    public enum TransferState {
        PENDING,
        SUCCESS,
        ;
    }

    /* ----------------------------------------------------------------- */
}
