package com.liquidnet.service.sweet.utils;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.feign.slime.api.FeignSlimeApiClient;
import com.liquidnet.service.slime.dto.vo.SlimeFieldsDetailsVo;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.SweetManualAppletFiveDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2FiveDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListFiveDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistStageListFiveDto;
import com.liquidnet.service.sweet.entity.SweetManualNotifyFive;
import com.liquidnet.service.sweet.entity.SweetManualShopFive;
import com.liquidnet.service.sweet.entity.SweetManualSortFive;
import com.liquidnet.service.sweet.entity.SweetRichtextFive;
import com.liquidnet.service.sweet.mapper.*;
import com.liquidnet.service.sweet.vo.SweetArtistsRelationVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.*;

@Component
public class RedisFiveDataUtils {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private QueueUtils queueUtils;

    @Autowired
    private SweetManualFiveMapper sweetManualFiveMapper;
    @Autowired
    private SweetManualArtistsFiveMapper sweetManualArtistsFiveMapper;
    @Autowired
    private SweetRichtextFiveMapper sweetRichtextFiveMapper;
    @Autowired
    private SweetManualSortFiveMapper sweetManualSortFiveMapper;
    @Autowired
    private SweetManualNotifyFiveMapper sweetManualNotifyFiveMapper;
    @Autowired
    private SweetManualShopFiveMapper sweetManualShopFiveMapper;
    @Autowired
    private SweetArtistsMapper sweetArtistsMapper;
    @Autowired
    private FeignSlimeApiClient feignSlimeApiClient;

    public List<SweetManualAppletFiveDto> setPushList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_PUSH_LIST;
        List<SweetManualAppletFiveDto> data = sweetManualFiveMapper.getManualAppletDto();
        for (SweetManualAppletFiveDto item : data) {
            if(!item.getIsMember().equals(1)){
                item.setTimeSell(DateUtil.format(DateUtil.addMin(DateUtil.parse(item.getTimeSell(),"yyyy-MM-dd HH:mm:ss"),-item.getPayCountdownMinute()),DateUtil.Formatter.yyyyMMddHHmmss));
            }
            SlimeFieldsDetailsVo slimeFieldsDetailsVo = feignSlimeApiClient.fieldDetails(item.getFieldId()).getData();
            String fieldName = slimeFieldsDetailsVo.getName();
            String cityName = slimeFieldsDetailsVo.getCityName();
            String latitude = slimeFieldsDetailsVo.getLatitude();
            String longitude = slimeFieldsDetailsVo.getLongitude();
            item.setFieldName(fieldName);
            item.setCityName(cityName);
            item.setLatitude(latitude);
            item.setLongitude(longitude);
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    //获取电子手册列表 (城市)
    public List<SweetManualAppletFiveDto> getPushList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_PUSH_LIST;
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setPushList();
        } else {
            return (List<SweetManualAppletFiveDto>) obj;
        }
    }

    //获取电子手册演出详情
    public SweetManualAppletFiveDto getAppletPerformance(String manualId) {
        List<SweetManualAppletFiveDto> data = getPushList();
        SweetManualAppletFiveDto returnData = SweetManualAppletFiveDto.getNew();
        for (SweetManualAppletFiveDto item : data) {
            if (item.getManualId().equalsIgnoreCase(manualId)) {
                returnData = item;
                break;
            }
        }
        return returnData;
    }

    public SweetManualArtistList2FiveDto setTimeList(String manualId, String content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_TIME_LIST.concat(manualId);
        HashMap<String, Object> map = CollectionUtil.mapStringObject();
        map.put("manualId", manualId);
        List<SweetManualArtistListFiveDto> data = sweetManualArtistsFiveMapper.getManualList(map);

        //获取时间
        SweetManualAppletFiveDto sweetManualAppletDto = getAppletPerformance(manualId);
        Date dateEnd = DateUtil.parse(sweetManualAppletDto.getTimeEnd(), DateUtil.DATE_SMALL_STR);
        Date dateStart = DateUtil.parse(sweetManualAppletDto.getTimeStart(), DateUtil.DATE_SMALL_STR);
        int intervalDay = (int) DateUtil.intervalDays(dateStart, dateEnd);
        ArrayList<String> list = CollectionUtil.arrayListString();
        list.add(DateUtil.format(dateStart, DateUtil.Formatter.yyyy_MM_dd));
        for (int i = 0; i < intervalDay; i++) {
            list.add(DateUtil.format(DateUtil.addDay(dateStart, i + 1), DateUtil.Formatter.yyyy_MM_dd));
        }

        //获取舞台
        List<SweetManualArtistStageListFiveDto> stageData = sweetManualArtistsFiveMapper.getStageNameList(map);

        SweetManualArtistList2FiveDto returnData = SweetManualArtistList2FiveDto.getNew();
        returnData.setDate(list);
        returnData.setData(data);
        returnData.setStage(stageData);
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    //获取时间表
    public SweetManualArtistList2FiveDto getTimeList(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_TIME_LIST.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTimeList(manualId, null);
        } else {
            return (SweetManualArtistList2FiveDto) obj;
        }
    }

    public SweetRichtextFive setRichTextRedisData(String manualId, String type, SweetRichtextFive content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_RICH_TEXT.concat(manualId).concat(":type:" + type);
        SweetRichtextFive sweetRichtext;
        if (content != null) {
            sweetRichtext = content;
        } else {
            sweetRichtext = sweetRichtextFiveMapper.selectOne(Wrappers.lambdaQuery(SweetRichtextFive.class).eq(SweetRichtextFive::getManualId, manualId).eq(SweetRichtextFive::getType, type));
        }
        redisUtil.set(redisKey, sweetRichtext);
        return sweetRichtext;
    }

    //获取富文本详情
    public SweetRichtextFive getRichTextRedisData(String manualId, String type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_RICH_TEXT.concat(manualId).concat(":type:" + type);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setRichTextRedisData(manualId, type, null);
        } else {
            return (SweetRichtextFive) obj;
        }
    }

    public List<String> setTagRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_SORT.concat(manualId);
        SweetManualSortFive data = sweetManualSortFiveMapper.selectOne(Wrappers.lambdaQuery(SweetManualSortFive.class).eq(SweetManualSortFive::getManualId, manualId));
        String[] arrays = data.getShowPosition().split(",");
        List<String> returnData = new ArrayList<>();
        for (String item : arrays) {
            returnData.add(item);
//            returnData.add(SweetConstant.ManualPosition.getMessage(item));
        }
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    //获取显示的标签
    public List<String> getTagRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_SORT.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTagRedisData(manualId);
        } else {
            return (List<String>) obj;
        }
    }

    public List<SweetManualNotifyFive> setNotifyRedisData(String manualId, List<SweetManualNotifyFive> content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_NOTIFY_LIST.concat(manualId);
        List<SweetManualNotifyFive> data;
        if (content != null) {
            data = content;
        } else {
            data = sweetManualNotifyFiveMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyFive.class).eq(SweetManualNotifyFive::getManualId, manualId).eq(SweetManualNotifyFive::getStatus, 1));
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    //获取通知
    public List<SweetManualNotifyFive> getNotifyRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_NOTIFY_LIST.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setNotifyRedisData(manualId, null);
        } else {
            return (List<SweetManualNotifyFive>) obj;
        }
    }

    public void deletePushListRedisData() {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_PUSH_LIST);//列表
    }

    public void deleteTimeListRedisData(String manualId) {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_TIME_LIST.concat(manualId));//列表
    }

    public void deleteSortRedisData(String manualId) {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_FIVE_MANUAL_SORT.concat(manualId));//列表
    }

    public void setArtistsRelationRedisVo(String uid, String artistsId, String manualId, String type) {

        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LocalDateTime now = LocalDateTime.now();

        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_ARTISTS_RELATION.concat(uid).concat(":manualId:").concat(manualId);
        SweetArtistsRelationVo vo = getArtistsRelationRedisVo(uid, manualId);
        vo.setUid(uid);
        if (type.equalsIgnoreCase("sign")) {
            if (vo.getSignList() == null) {
                ArrayList<String> signList = CollectionUtil.arrayListString();
                signList.add(artistsId);
                vo.setSignList(signList);
                sqls.add(SqlMapping.get("sweet_user_relation_five.insert"));
                sqlsDataA.add(new Object[]{
                        uid, 2, artistsId, manualId, now
                });
            } else {
                if (vo.getSignList().contains(artistsId)) {
                    vo.getSignList().remove(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_five.delete"));
                    sqlsDataA.add(new Object[]{
                            uid, artistsId, manualId,2
                    });
                } else {
                    vo.getSignList().add(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_five.insert"));
                    sqlsDataA.add(new Object[]{
                            uid, 2, artistsId, manualId, now
                    });
                }
            }
        } else if (type.equalsIgnoreCase("watch")) {
            if (vo.getWatchList() == null) {
                ArrayList<String> watchList = CollectionUtil.arrayListString();
                watchList.add(artistsId);
                vo.setWatchList(watchList);
                sqls.add(SqlMapping.get("sweet_user_relation_five.insert"));
                sqlsDataA.add(new Object[]{
                        uid, 1, artistsId, manualId, now
                });
            } else {
                if (vo.getWatchList().contains(artistsId)) {
                    vo.getWatchList().remove(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_five.delete"));
                    sqlsDataA.add(new Object[]{
                            uid, artistsId, manualId,1
                    });
                } else {
                    vo.getWatchList().add(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_five.insert"));
                    sqlsDataA.add(new Object[]{
                            uid, 1, artistsId, manualId, now
                    });
                }
            }
        }
        redisUtil.set(redisKey, vo);

        queueUtils.sendMsgByRedis(MQConst.SweetQueue.ARTISTS_RELATION.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));
    }

    //获取 签售
    //获取 想看
    public SweetArtistsRelationVo getArtistsRelationRedisVo(String uid, String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_ARTISTS_RELATION.concat(uid).concat(":manualId:").concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return SweetArtistsRelationVo.getNew();
        } else {
            return (SweetArtistsRelationVo) obj;
        }
    }

    //获取 商铺
    public List<SweetManualShopFive> setManualShopRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_SHOP.concat(manualId);
        List<SweetManualShopFive> list = sweetManualShopFiveMapper.selectList(Wrappers.lambdaQuery(SweetManualShopFive.class).eq(SweetManualShopFive::getManualId, manualId).orderBy(true, false, SweetManualShopFive::getSort));
        redisUtil.set(redisKey, list);
        return list;
    }

    public List<SweetManualShopFive> getManualShopRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_SHOP.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setManualShopRedisData(manualId);
        } else {
            return (List<SweetManualShopFive>) obj;
        }
    }

//    // 艺人详情
//    public SweetArtists setArtistsDetails(String artistsId) {
//        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_ARTISTS_DETAILS.concat(artistsId);
//        SweetArtists sweetArtists = sweetArtistsMapper.selectOne(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId).eq(SweetArtists::getStatus, 1));
//        redisUtil.set(redisKey, sweetArtists);
//        return sweetArtists;
//    }
//
//    public SweetArtists getArtistsDetails(String artistsId) {
//        String redisKey = SweetConstant.REDIS_KEY_SWEET_FIVE_ARTISTS_DETAILS.concat(artistsId);
//        Object obj = redisUtil.get(redisKey);
//        if (obj == null) {
//            return setArtistsDetails(artistsId);
//        } else {
//            return (SweetArtists) obj;
//        }
//    }
}
