package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinBackOrderDetailsVo;
import com.liquidnet.service.goblin.dto.vo.GoblinBackOrderVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreBackOrderListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderListVo;
import com.liquidnet.service.goblin.param.RefundCallbackParam;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreBackOrderService;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.math.BigDecimal;

@ApiSupport(order = 149101)
@Api(tags = "店铺-订单")
@Slf4j
@Validated
@RestController
@RequestMapping("store/orderBack")
public class GoblinStoreBackOrderController {
    @Autowired
    IGoblinStoreBackOrderService goblinStoreBackOrderService;

    @ApiOperation(value = "订单列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderBackCode", value = "订单退款编号"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "type", value = "退款类型[0-全部|1-退款|2-退货|3-退款退货]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "cst", value = "申请起始时间"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "cet", value = "申请终止时间"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderCode", value = "订单编号"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "spuName", value = "商品名称"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "status", value = "订单状态[1-待处理|2-已退款|9-已拒绝|11-已取消|0-退款中|7-退货中]"),
    })
    @GetMapping(value = "list")
    public ResponseDto<PageInfo<GoblinStoreBackOrderListVo>> orderBackList(@RequestParam(value = "page", required = true) @Valid Integer page,
                                                                           @RequestParam(value = "orderBackCode", required = false) String orderBackCode,
                                                                           @RequestParam(value = "type", required = false) Integer type,
                                                                           @RequestParam(value = "cst", required = false) String cst,
                                                                           @RequestParam(value = "cet", required = false) String cet,
                                                                           @RequestParam(value = "orderCode", required = false) String orderCode,
                                                                           @RequestParam(value = "spuName", required = false) String spuName,
                                                                           @RequestParam(value = "status", required = false) Integer status) {

        return goblinStoreBackOrderService.orderBackList(page, orderBackCode, type, cst, cet, orderCode, spuName, status);
    }

    @ApiOperation(value = "退款订单详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "backOrderId", value = "订单id"),
    })
    @GetMapping(value = "details")
    public ResponseDto<GoblinBackOrderDetailsVo> orderList(@RequestParam(value = "backOrderId", required = true) @Valid String backOrderId) {
        return goblinStoreBackOrderService.orderDetails(backOrderId);
    }

//    @ApiOperation(value = "同意退款")
//    @ApiImplicitParams({
//            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "backOrderId", value = "订单id"),
//    })
//    @GetMapping(value = "agree")
//    public ResponseDto<Boolean> agreeRefund(@RequestParam(value = "backOrderId", required = true) @Valid String backOrderId) {
//        return goblinStoreBackOrderService.agreeRefund(backOrderId);
//    }
//
    @ApiOperation(value = "拒绝退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "backOrderId", value = "订单id"),
    })
    @GetMapping(value = "refused")
    public ResponseDto<Boolean> refusedRefund(@RequestParam(value = "backOrderId", required = true) @Valid String backOrderId) {
        return goblinStoreBackOrderService.refusedRefund(backOrderId);
    }

    @ApiOperation(value = "修改金额")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "backOrderId", value = "订单id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "changeType", value = "类型[1-物流金额|2-退款金额]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Number", name = "refundPrice", value = "价格"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderSkuId", value = "orderSkuId"),
    })
    @GetMapping(value = "change")
    public ResponseDto<Boolean> changeRefund(@RequestParam(value = "backOrderId", required = true) @Valid String backOrderId,
                                             @RequestParam(value = "changeType", required = true) @Valid Integer changeType,
                                             @RequestParam(value = "refundPrice", required = true) @Valid BigDecimal refundPrice,
                                             @RequestParam(value = "orderSkuId", required = false) String orderSkuId) {
        if (changeType == 1) {
            return goblinStoreBackOrderService.changeExpressRefund(backOrderId, refundPrice);
        } else if (changeType == 2) {
            return goblinStoreBackOrderService.changeSkuRefund(backOrderId, refundPrice, orderSkuId);
        } else {
            return ResponseDto.failure("参数异常");
        }
    }
}
