package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreConfigVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class GoblinStoreMgtServiceImpl implements IGoblinStoreMgtService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public boolean updateStoreMgtInfo(GoblinStoreInfoVo storeInfoVo) {
        if (goblinMongoUtils.updateStoreInfoVo(storeInfoVo)) {
//            goblinRedisUtils.setStoreInfoVo(storeInfoVo);// TODO: 2022/1/17 zhanggb==

            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.get("goblin_store_info.update_by_edit",
                            storeInfoVo.getStoreName(), storeInfoVo.getLogoPic(), storeInfoVo.getBackgroundPic(), storeInfoVo.getIntroduce(),
                            storeInfoVo.getUpdatedBy(), storeInfoVo.getUpdatedAt(), storeInfoVo.getStoreId()
                    ));
            return true;
        }
        return false;
    }

    @Override
    public boolean updateStoreMgtConfig(String uid, String storeId, Map<String, String> confMap) {
        LocalDateTime now = LocalDateTime.now();
        List<GoblinStoreConfigVo> storeConfigVos = goblinRedisUtils.getStoreConfigVos(storeId);
        List<GoblinStoreConfigVo> updateStoreConfigVoList = ObjectUtil.getGoblinStoreConfigVoArrayList();
        storeConfigVos.forEach(configVo -> {
            String updateConfVal = confMap.get(configVo.getConfigKey());
            if (StringUtils.isNotEmpty(updateConfVal)) {
                configVo.setConfigVal(updateConfVal);
                configVo.setUpdatedBy(uid);
                configVo.setUpdatedAt(now);
                updateStoreConfigVoList.add(configVo);
            }
        });
        if (!CollectionUtils.isEmpty(updateStoreConfigVoList) && goblinMongoUtils.updateStoreConfigVos(updateStoreConfigVoList)) {
//            goblinRedisUtils.setStoreConfigVos(storeId, storeConfigVos);// TODO: 2022/1/17 zhanggb==

            LinkedList<Object[]> updateStoreConfigVoObjs = CollectionUtil.linkedListObjectArr();
            updateStoreConfigVoList.forEach(uc -> updateStoreConfigVoObjs.add(new Object[]{uc.getConfigVal(), uc.getUpdatedBy(), uc.getUpdatedAt(), uc.getStoreId(), uc.getConfigKey()}));
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.get("goblin_store_config.update", updateStoreConfigVoObjs));
            return true;
        }
        return false;
    }
}
