package com.liquidnet.service.kylin.mapper;

import com.liquidnet.service.kylin.dao.KylinOrderRefundsEntitiesDao;
import com.liquidnet.service.kylin.dao.KylinOrderTicketEntitiesDao;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 订单详情 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
public interface KylinOrderTicketEntitiesMapper extends BaseMapper<KylinOrderTicketEntities> {

    List<KylinOrderRefundsEntitiesDao> selectEntitiesList(@Param("orderTicketEntitiesIdS") List<String> orderTicketEntitiesIdS);

    List<KylinOrderTicketEntitiesDao> getRefundEntitiesList(String orderTicketsId);

    Double getRefundEntitiesPrice(
            @Param("orderTicketsId") String orderTicketsId,
            @Param("orderRefundStatusCancel") Integer orderRefundStatusCancel,
            @Param("orderTicketEntitiesId") String orderTicketEntitiesId
    );

    Double getRefundOverEntitiesPrice(
            @Param("orderTicketsId") String orderTicketsId,
            @Param("orderRefundStatus") Integer orderRefundStatus,
            @Param("entitiesId") String entitiesId
    );
}
