package com.liquidnet.service.stone.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.UserPathDto;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.service.IStoneScoreItemsService;
import com.liquidnet.service.stone.util.ObjectUtils;
import com.liquidnet.service.stone.util.StoneMongoUtils;
import com.liquidnet.service.stone.util.StoneRedisUtils;
import com.liquidnet.service.stone.vo.StoneItemListVo;
import com.liquidnet.service.stone.vo.StoneScoreItemVo;
import io.netty.util.internal.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 积分物品表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Service
@Slf4j
public class StoneScoreItemsServiceImpl implements IStoneScoreItemsService {

    @Autowired
    private StoneRedisUtils redisUtils;
    @Autowired
    private StoneMongoUtils mongoUtils;

    @Override
    public PageInfo<List<StoneItemListVo>> itemList(Integer page, Integer size) {
        PageInfo<List<StoneItemListVo>> mPageInfo;
        size = 40;
        if (page == null || page == 1 || page == 0) {
            page = 1;
        }
        List<StoneScoreItems> voList;
        long count;
        if (page == 1) {
            voList = redisUtils.getList();
            count = voList.size();
        } else {
            HashMap<String, Object> info = mongoUtils.itemListPage(page, size, null);
            try {
                voList = (List<StoneScoreItems>) info.get("data");
            } catch (Exception e) {
                voList = new ArrayList();
                e.printStackTrace();
            }
            count = 40 + (long) info.get("total");
        }

        List<StoneItemListVo> returnVoList = ObjectUtils.getStoneItemListVoArrayList();
        for (int i = 0; i < voList.size(); i++) {
            StoneScoreItems vo = voList.get(i);
            StoneItemListVo returnVo = StoneItemListVo.getNew().copy(vo);
            returnVoList.add(returnVo);
        }

        mPageInfo = new PageInfo(returnVoList);
        mPageInfo.setTotal(count);

        log.info(UserPathDto.setData("积分商品列表", "", voList));
        return mPageInfo;
    }

    @Override
    public PageInfo<List<StoneItemListVo>> itemListSimpleType(Integer simpleType, Integer page, Integer size) {
        PageInfo<List<StoneItemListVo>> mPageInfo;
        size = 40;
        if (page == null || page == 1 || page == 0) {
            page = 1;
        }
        List<StoneScoreItems> voList;
        long count;
        if (page == 1) {
            voList = redisUtils.getListSimple(simpleType.toString());
            count = voList.size();
        } else {
            HashMap<String, Object> info = mongoUtils.itemListPage(page, size, simpleType.toString());
            try {
                voList = (List<StoneScoreItems>) info.get("data");
            } catch (Exception e) {
                voList = new ArrayList();
                e.printStackTrace();
            }
            count = 40 + (long) info.get("total");
        }

        List<StoneItemListVo> returnVoList = ObjectUtils.getStoneItemListVoArrayList();
        for (int i = 0; i < voList.size(); i++) {
            StoneScoreItems vo = voList.get(i);
            StoneItemListVo returnVo = StoneItemListVo.getNew().copy(vo);
            returnVoList.add(returnVo);
        }

        mPageInfo = new PageInfo(returnVoList);
        mPageInfo.setTotal(count);

        log.info(UserPathDto.setData("积分商品列表", "", voList));
        return mPageInfo;
    }

    @Override
    public ResponseDto<StoneScoreItemVo> itemDetails(String itemId) {
        String uid = CurrentUtil.getCurrentUid();
        StoneScoreItems data = redisUtils.getItemData(itemId);
        int restCount = redisUtils.getStoneGeneralSurplus(itemId);
        int restScore = redisUtils.getUserScoreRest(uid);
        int singleScore = data.getScore().intValue();
        int buyCount = redisUtils.getItemLimit(uid, itemId);
        int limitCount = data.getLimitCount();
        int scoreStatus = 2;
        int limitStatus = 2;
        //判断库存
        if (restCount <= 0) {
            data.setStatus(8);
        } else if (restCount <= 50) {
            data.setStatus(9);
        }
        //判断积分是否够
        if (singleScore > restScore) {
            scoreStatus = 2;
        } else {
            scoreStatus = 1;
        }
        //判断积分是否够
        if (buyCount >= limitCount) {
            limitStatus = 2;
        } else {
            limitStatus = 1;
        }
        StoneScoreItemVo vo = StoneScoreItemVo.getNew().copy(data, scoreStatus, limitStatus);
        return ResponseDto.success(vo);
    }
}
