package com.liquidnet.service.stone.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.liquidnet.service.stone.dto.StoneScoreListDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分用户表
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class StoneScoreUser implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * id
     */
    private String scoreId;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 状态[1-正常|2-冻结]
     */
    private Integer status;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


    private static final StoneScoreUser obj = new StoneScoreUser();
    public static StoneScoreUser getNew() {
        try {
            return (StoneScoreUser) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new StoneScoreUser();
    }

}
