package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetManualDto;
import com.liquidnet.service.sweet.entity.SweetManualArtists;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.mapper.SweetManualArtistsMapper;
import com.liquidnet.service.sweet.service.ISweetManualArtistsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 电子宣传手册艺人表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Service
public class SweetManualArtistsServiceImpl extends ServiceImpl<SweetManualArtistsMapper, SweetManualArtists> implements ISweetManualArtistsService {

    @Autowired
    private SweetManualArtistsMapper sweetManualArtistsMapper;

    @Override
    public ResponseDto<PageInfo<SweetManualArtistListDto>> getList(Integer page, Integer size, String manualId) {
        PageInfo<SweetManualArtistListDto> pageInfoTmp;
        try {
            PageHelper.startPage(page, size);
            HashMap<String, Object> map = new HashMap<>();
            map.put("manualId", manualId);
            List<SweetManualArtistListDto> voList = sweetManualArtistsMapper.getManualList(map);
            pageInfoTmp = new PageInfo(voList);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
        return ResponseDto.success(pageInfoTmp);
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String artistId, String stageId, String performanceStart, String performanceEnd, String signatureStart, String signatureEnd) {
        try {
            SweetManualArtists sweetManualNotify = new SweetManualArtists();
            sweetManualNotify.setManualRelationId(IDGenerator.nextSnowId());
            sweetManualNotify.setManualId(manualId);
            sweetManualNotify.setStageId(stageId);
            sweetManualNotify.setArtistsId(artistId);
            sweetManualNotify.setPerformanceEnd(performanceEnd != null ? DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceEnd) : null);
            sweetManualNotify.setPerformanceStart(performanceStart != null ? DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceStart) : null);
            sweetManualNotify.setSignatureStart(signatureStart != null ? DateUtil.Formatter.yyyyMMddHHmmss.parse(signatureStart) : null);
            sweetManualNotify.setSignatureEnd(signatureEnd != null ? DateUtil.Formatter.yyyyMMddHHmmss.parse(signatureEnd) : null);
            sweetManualNotify.setCreatedAt(LocalDateTime.now());
            sweetManualArtistsMapper.insert(sweetManualNotify);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualArtistListDto> details(String manualRelationId) {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("manualRelationId", manualRelationId);
            SweetManualArtistListDto dto = sweetManualArtistsMapper.getManualDetails(map);
            return ResponseDto.success(dto);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualRelationId, String artistId, String stageId, String performanceStart, String performanceEnd, String signatureStart, String signatureEnd) {
        try {
            SweetManualArtists sweetManualNotify = new SweetManualArtists();
            sweetManualNotify.setManualRelationId(IDGenerator.nextSnowId());
            sweetManualNotify.setStageId(stageId);
            sweetManualNotify.setArtistsId(artistId);
            sweetManualNotify.setPerformanceEnd(DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceEnd));
            sweetManualNotify.setPerformanceStart(DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceStart));
            sweetManualNotify.setSignatureStart(DateUtil.Formatter.yyyyMMddHHmmss.parse(signatureStart));
            sweetManualNotify.setSignatureEnd(DateUtil.Formatter.yyyyMMddHHmmss.parse(signatureEnd));
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualArtistsMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualArtists.class).eq(SweetManualArtists::getManualRelationId, manualRelationId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualRelationId) {
        try {
            SweetManualArtists sweetManualNotify = new SweetManualArtists();
            sweetManualNotify.setManualRelationId(IDGenerator.nextSnowId());
            sweetManualNotify.setStatus(0);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualArtistsMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualArtists.class).eq(SweetManualArtists::getManualRelationId, manualRelationId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }
}
