package com.liquidnet.common.third.zxlnft.constant;

import java.util.Arrays;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ErrorEnum
 * @Package com.liquidnet.common.third.zxlnft.constant
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/21 14:00
 */
public enum ZxlErrorEnum {
    SECCESS("0","成功"),
    FAILURE("1","失败"),
    NO_INIT_ERROR("000", "没有初始化"),
    APP_TYPE_ERROR("001", "应用类型错误"),
    INVALID_PARAM_ERROR("002", "参数错误"),
    GENERATE_KEYPAIR_ERROR("003", "生成公私钥错误"),
    SIGN_ERROR("004", "签名错误"),
    VERIFY_ERROR("005", "验签错误"),
    ENCRYPT_ERROR("006", "加密数据错误"),
    DECODE_ERROR("007", "解密数据错误"),
    CALCULATE_FILE_HASH_ERROR("008", "计算文件hash错误"),
    BIND_USER_CERT_ERROR("009", "绑定用户证书错误"),
    UPDATE_USER_CERT_ERROR("010", "更新用户证书错误"),
    APPLY_EVIDENCE_ERROR("011", "申请存证错误"),
    SAVE_EVIDENCE_ERROR("012", "存证错误"),
    QUERY_EVIDENCE_ERROR("013", "查询存证错误"),
    AUTHOR_LIMIT_ERROR("027", "作者数量超限错误"),
    CALCULATE_HASH_ERROR("014", "计算字符串hash错误"),
    EVIDENCE_HASH_IS_NULL("016", "存证hash为空"),
    ISSUE_TASK_ERROR("017", "下发任务失败"),
    EVIDENCE_HASH_CAL_SM3("018", "存证hash摘要算法不通过,仅支持SM3"),
    QUERY_OBTAIN_TASK_ERROR("019", "获取取证任务结果失败"),
    OBTAIN_TASK_FAIL("020", "取证失败"),
    QUERY_CERT_FAIL("021", "获取取证证书信息失败"),
    URL_INVALID("022", "url不合规，请检查"),
    DATE_INVALID("023", "时间不合规，请检查"),
    CREATE_TORT_TASK_ERR("024", "创建侵权监控任务失败"),
    FILE_AND_URL_NOT_MATCH("025", "evHash与url文件的hash不匹配"),
    URL_OR_NETWORK_ERR("026", "url地址不正确或者网络不佳，文件下载失败"),
    PARAM_FORMAT_ERROR("461000", "参数格式错误"),
    INVALID_APP_ERROR("461010", "无效的用户appid"),
    PACKAGE_CLOSE_ERROR("562012", "用户消费套餐已被关闭"),
    NO_PACKAGE_ERROR("562013", "没有可用的消费套餐"),
    SERVER_INNER_ERROR("562014", "内部错误"),
    ORDER_NOT_FOUND_ERROR("-101", "此编号未查到对应信息"),
    SERVER_ERROR("3108", "服务不可用,调用后端服务失败"),
    UPDATE_CONSUME_ERROR("563006", "更新消费流水状态失败"),
    MID_SERVER_ERROR("022", "中间件服务异常"),
    TORT_SOURCE_ERROR("6026", "侵权 Source 类型错误");
    private String code;
    private String msg;
    ZxlErrorEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }
    public String getCode() { return this.code; }
    public String getMsg() { return this.msg; }
    public static String errorMsg(String content) {
        ZxlErrorEnum err = Arrays.<ZxlErrorEnum>asList(values()).stream().filter(errorEnum -> errorEnum.getCode().equals(content)).findFirst().orElse(SERVER_INNER_ERROR);
        return err.getMsg();
    }
}