package com.liquidnet.common.third.zxlnft.util;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.nft.Nft022UploadSecretReq;
import com.liquidnet.common.third.zxlnft.dto.nft.Nft022UploadSecretResp;
import com.liquidnet.common.third.zxlnft.dto.wallet.*;
import com.liquidnet.common.third.zxlnft.service.WalletSdkService;
import com.liquidnet.common.third.zxlnft.service.ZxlnftSdkService;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxlWalletSdkUtil
 * @Package com.liquidnet.common.third.zxlnft.util
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/2/24 16:08
 */
@Slf4j
@Component
public class ZxlWalletSdkUtil {
    @Autowired
    private ZxlnftConfig zxlnftConfig;
    @Autowired
    private WalletSdkService walletSdkService;
    @Autowired
    private ZxlnftSdkService zxlnftSdkService;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    /**
     * 1、生成助记词
     * @param req
     * @return
     */
    public CreateMnemonicResp createMnemonic(CreateMnemonicReq req){
        CreateMnemonicResp resp = walletSdkService.createMnemonic(req);
        return resp;
    }

    /**
     * 2、API签名
     * @param req
     * @return
     */
    public GenerateApiSignResp generateApiSign(GenerateApiSignReq req){
        GenerateApiSignResp resp = walletSdkService.generateApiSign(req);
        return resp;
    }

    /**
     * 3、文件上传至COS
     * @param req
     * @return
     */
    public UploadToCosResp uploadToCos(UploadToCosReq req,String seriesName){
        //获取临时密钥
        Nft022UploadSecretReq nft022Req = Nft022UploadSecretReq.getNew();
        nft022Req.setTimestamp(DateUtil.getNowSeconds().toString());
        nft022Req.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        nft022Req.setUserPubKey(zxlnftConfig.getNftPlatformPubKey());

        //系列为空
        String pubData = nft022Req.getTimestamp() + "_" + nft022Req.getUserPubKey();
        String userData = nft022Req.getTimestamp();
        //系列不为空
        if(StringUtil.isNotEmpty(seriesName)){
            nft022Req.setSeriesName(seriesName);
            pubData = nft022Req.getTimestamp() + "_" + nft022Req.getSeriesName() + "_" + nft022Req.getUserPubKey();
            userData = nft022Req.getTimestamp() + "_" + nft022Req.getSeriesName();
        }

        nft022Req.setPubSignedData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),pubData));
        nft022Req.setUserSignedData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),userData));
        Nft022UploadSecretResp nft022Resp = zxlnftSdkService.nft022UploadSecret(nft022Req);

        //执行上传
        req.setCosPath(nft022Resp.getUploadAddress() + "2022-02-24/" + IDGenerator.getZxlNftImageCosCode()+".jpg");
        req.setTempSecretId(nft022Resp.getTempSecretId());
        req.setTempSecretKey(nft022Resp.getTempSecretKey());
        req.setSessionToken(nft022Resp.getSessionToken());
        req.setFilePath(req.getFilePath());
        UploadToCosResp resp = walletSdkService.uploadToCos(req);
        return resp;
    }

    /**
     * 4、文件上传至COS(form-data文件提交)
     * @param req
     * @return
     */
    public UploadFileToCosResp uploadFileToCos(UploadFileToCosReq req){
        //获取临时密钥
        Nft022UploadSecretReq nft022Req = Nft022UploadSecretReq.getNew();
        Nft022UploadSecretResp nft022Resp = zxlnftSdkService.nft022UploadSecret(nft022Req);

        //执行上传
        UploadFileToCosResp resp = walletSdkService.uploadFileToCos(req);
        return resp;
    }

    /**
     * 5、派生生成子公私钥对
     * @param req
     * @return
     */
    public DeriveKeyPairResp deriveKeyPair(DeriveKeyPairReq req){
        DeriveKeyPairResp resp = walletSdkService.deriveKeyPair(req);
        return resp;
    }

    /**
     * 6、SDK签名
     * @param req
     * @return
     */
    public SignByPriKeyResp signByPriKey(SignByPriKeyReq req){
        SignByPriKeyResp resp = walletSdkService.signByPriKey(req);
        return resp;
    }

    /**
     * 7、私钥生成对应公钥
     * @param req
     * @return
     */
    public PriKey2PubKeyResp priKey2PubKey(PriKey2PubKeyReq req){
        PriKey2PubKeyResp resp = walletSdkService.priKey2PubKey(req);
        return resp;
    }

    /**
     * 8、公钥生成对应地址
     * @param req
     * @return
     */
    public PubKey2AddressResp pubKey2Address(PubKey2AddressReq req){
        PubKey2AddressResp resp = walletSdkService.pubKey2Address(req);
        return resp;
    }

    /**
     * 9、私钥生成对应地址
     * @param req
     * @return
     */
    public PriKey2AddressResp priKey2Address(PriKey2AddressReq req){
        PriKey2AddressResp resp = walletSdkService.priKey2Address(req);
        return resp;
    }

    /**
     * 10、SDK验签
     * @param req
     * @return
     */
    public VerifyByPubKeyResp verifyByPubKey(VerifyByPubKeyReq req){
        VerifyByPubKeyResp resp = walletSdkService.verifyByPubKey(req);
        return resp;
    }

    /**
     * 11、SDK-SM3哈希
     * @param req
     * @return
     */
    public SM3HashResp sM3Hash(SM3HashReq req){
        SM3HashResp resp = walletSdkService.sM3Hash(req);
        return resp;
    }

    /**
     * 12、SDK-SM3哈希EnCode
     * @param req
     * @return
     */
    public SM3HashEncodeResp sM3HashEncode(SM3HashEncodeReq req){
        SM3HashEncodeResp resp = walletSdkService.sM3HashEncode(req);
        return resp;
    }
}
