package com.liquidnet.service.adam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.adam.dto.AdamMemberOrderCallbackResult;
import com.liquidnet.service.adam.dto.AdamMemberOrderCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderResult;
import com.liquidnet.service.adam.dto.vo.AdamMemberOrderVo;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import com.liquidnet.service.base.ResponseDto;

import java.util.List;

/**
 * 对客户端API接口
 */
public interface IAdamMemberOrderService extends IService<AdamMemberOrder> {
    /**
     * 购买会员或会员码
     *
     * @param param
     */
    ResponseDto<AdamMemberOrderResult> buyMemberOrMemberCode(AdamMemberOrderParam param) throws Exception;

    /**
     * 使用会员码
     * @param param
     * @return
     */
    ResponseDto<AdamMemberOrderResult> useMemberCode(AdamMemberOrderCodeParam param);

    /**
     * 获取订单列表
     * @param uid
     * @return
     */
    List<AdamMemberOrderVo> getMemberOrderList(String uid);

    /**
     * 获取订单详情信息
     *
     * @param orderNo 订单号
     * @return
     */
    AdamMemberOrderVo getMemberOrderInfo(String uid,String orderNo);

    /**
     * 支付回调
     * @return
     */
    boolean memberNotifyCallBack(AdamMemberOrderCallbackResult result);

}
