package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.kylin.utils.DataUtils;
import com.liquidnet.client.admin.zhengzai.kylin.utils.PerformanceVoUtils;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.kylin.dao.*;
import com.liquidnet.service.kylin.dto.param.*;
import com.liquidnet.service.kylin.dto.vo.admin.KylinPerformanceAgentVo;
import com.liquidnet.service.kylin.dto.vo.admin.KylinPerformanceDamaiVo;
import com.liquidnet.service.kylin.dto.vo.admin.KylinPerformanceMemberHistoryVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
@Slf4j
public class PerformancesExpressServiceImpl extends ServiceImpl<KylinPerformancesMapper, KylinPerformances> {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private PerformanceVoUtils performanceVoUtils;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    public KylinPerformanceMisVo performanceDetails(String performancesId) {
        log.info(" PERFORMANCE  mis演出详情");
        KylinPerformanceMisVo createMisVo = performanceVoUtils.getPerformanceMisVo(performancesId);
        return createMisVo;
    }

    public List<PerformanceExpressAdminListDao> getList(PerformanceExpressAdminListParam performanceExpressAdminListParam) {
        List<PerformanceExpressAdminListDao> voList = new ArrayList();
        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(performanceExpressAdminListParam);
            voList = performancesMapper.misPerformanceExpressList(map);
            for (PerformanceExpressAdminListDao item : voList) {
                item.setStatus(item.getStatus());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return voList;
    }

}
