package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.service.consumer.kylin.receiver.ConsumerKylinSqlStationRdsReceiver;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerKylinTransferRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_STATION;
import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_TRANSFER;

@Configuration
public class ConsumerKylinSqlTransferRedisStreamConfig {
    @Autowired
    ConsumerKylinTransferRdsReceiver consumerKylinTransferRdsReceiver;

    private StreamMessageListenerContainer<String, MapRecord<String, String, String>> buildStreamMessageListenerContainer(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        return StreamMessageListenerContainer.create(factory, options);
    }

    /**
     * 验票更新
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveTransfer(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(SQL_TRANSFER.getGroup(), SQL_TRANSFER.name() + t),
                StreamOffset.create(SQL_TRANSFER.getKey(), ReadOffset.lastConsumed()), consumerKylinTransferRdsReceiver
        );
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 验票更新 */

    @Bean
    public Subscription subscriptionReceiveTransfer1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveTransfer(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionReceiveTransfer2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveTransfer(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionReceiveTransfer3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveTransfer(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionReceiveTransfer4(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveTransfer(listenerContainer, 4);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionReceiveTransfer5(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveTransfer(listenerContainer, 5);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
