package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftPublishResultQueryReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 11:22
 */
@ApiModel(value = "GalaxyNftPublishResultQueryReqDto", description = "NFT发行结果查询")
@Data
public class GalaxyNftPublishResultQueryReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    /**
     * nftOrderPayId
     */
    @ApiModelProperty(position = 1, required = true, value = "nft订单支付id(保证唯一)，不超过30个字符")
    @NotBlank(message = "nft订单支付id不能为空")
    @Size(min = 2, max = 30, message = "nft订单支付id限制2-30位且不能包含特殊字符")
    private String nftOrderPayId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishResultQueryReqDto obj = new GalaxyNftPublishResultQueryReqDto();

    public static GalaxyNftPublishResultQueryReqDto getNew() {
        try {
            return (GalaxyNftPublishResultQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishResultQueryReqDto();
        }
    }
}
