package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel
public class GoblinMailVo implements Serializable, Cloneable {

    @ApiModelProperty(value = " 快递单号")
    private String mailId;
    @ApiModelProperty(value = " 订单id")
    private String orderId;
    @ApiModelProperty(value = " 快递单号")
    private String mailNo;
    @ApiModelProperty(value = " 发货时间")
    private String deliveryTime;
    @ApiModelProperty(value = " 物流公司姓名")
    private String logisticsCompany;
    @ApiModelProperty(value = " 物流公司code[物流公司id]")
    private String logisticsCode;
    @ApiModelProperty(value = "orderSkuId")
    private List<String> orderSkuVoIds;
    @ApiModelProperty(value = "orderSkuVo")
    private List<GoblinOrderSkuVo> orderSkuVos;

    private static final GoblinMailVo obj = new GoblinMailVo();

    public static GoblinMailVo getNew() {
        try {
            return (GoblinMailVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinMailVo();
    }

}
