package com.liquidnet.service.goblin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.vo.HelpValueVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateHelpVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关(前)")
@RequestMapping("/anticipate")
public class GoblinGoodsAnticipateController {

    @Autowired
    IGoblinGoodsAnticipateService goblinGoodsAnticipateService;

    @ApiOperation("用户预约 （只能预约不能取消）")
    @PostMapping("/userAbout")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId", example = ""),
    })
    public ResponseDto<Boolean> userAbout(@RequestParam(name = "skuId", required = true) String skuId) {
        return goblinGoodsAnticipateService.userAbout(skuId);
    }

    @ApiOperation("根据skuId和uid查询是否预约")
    @GetMapping("/selectAnticipateBySkuIdAndUid")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId", example = ""),
    })
    public ResponseDto<Boolean> selectAnticipate(@RequestParam(name = "skuId") String skuId) {
        return goblinGoodsAnticipateService.selectAnticipate(skuId);
    }

    @ApiOperation("用户分享,根据sku发起助力")
    @PostMapping("/share")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId", example = ""),
    })
    public ResponseDto<String> share(@RequestParam(name = "skuId", required = true) String skuId) {
        return goblinGoodsAnticipateService.share(skuId);
    }

    @ApiOperation("用户为他人助力")
    @PostMapping("help")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "sid", value = "创建分享生成的sid", example = ""),
    })
    public ResponseDto<Boolean> help(@RequestParam(name = "sid", required = true) String sid) {
        return goblinGoodsAnticipateService.help(sid);
    }

    @ApiOperation("获取当前助力信息")
    @PostMapping("getHelpValue")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "sid", value = "创建分享生成的sid", example = ""),
    })
    public ResponseDto<HelpValueVo> getHelpValue(@RequestParam(name = "sid", required = true) String sid) {
        return goblinGoodsAnticipateService.getHelpValue(sid);
    }

    @ApiOperation("是否开启助力(返回助力的sid,返回null则没有开启助力)")
    @GetMapping("getTurnOnHelp")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId", example = ""),
    })
    public ResponseDto<String> getTurnOnHelp(@RequestParam(name = "skuId") String skuId){
        return goblinGoodsAnticipateService.getTurnOnHelp(skuId);
    }

}
