package com.liquidnet.service.kylin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
@ApiModel(value = "福袋兑换码详情VO")
public class KylinLuckyBagCodeDetailVo {

    @ApiModelProperty(value = "福袋ID")
    private String luckyBagId;

    @ApiModelProperty(value = "福袋名称")
    private String luckyBagName;

    @ApiModelProperty(value = "兑换码")
    private String code;

    @ApiModelProperty(value = "状态 0：不可用 1：可用 2：已领取")
    private int state;

    @ApiModelProperty(value = "发放时间")
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "领取时间")
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime updatedAt;


    @ApiModelProperty(value = "领取人信息")
    private UserInfo userInfo;


    @ApiModelProperty(value = "关联订单订单")
    private OrderInfo orderInfo;


    @ApiModel(value = "用户信息")
    @Data
    public static class UserInfo {
        @ApiModelProperty(value = "用户ID")
        private String uid;
        @ApiModelProperty(value = "用户昵称")
        private String userName;
        @ApiModelProperty(value = "用户手机号")
        private String userMobile;
    }

    @ApiModel(value = "订单信息")
    @Data
    public static class OrderInfo {
        @ApiModelProperty(value = "订单ID")
        private String orderId;
        @ApiModelProperty(position = 15, value = "订单号")
        private String orderCode;
        @ApiModelProperty(value = "演出名称")
        private String performanceTitle;
        @ApiModelProperty(value = "票种名称")
        private String ticketTitle;
        @ApiModelProperty(value = "数量")
        private Integer number;
        @ApiModelProperty(value = "订单生成时间")
        private String createdAt;
        @ApiModelProperty(value = "适用时间")
        private String useStart;
    }


}
