package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 商城订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinAppOrderDetailsVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = " orderVo")
    private GoblinStoreOrderVo storeOrderVo;
    @ApiModelProperty(value = " orderSkuVo")
    List<GoblinOrderSkuVo> orderSkuVos;
    @ApiModelProperty(value = "过期倒计时")
    private Long restTime;
    @ApiModelProperty(value = "是否可退款")
    private int canRefund;
    @ApiModelProperty(value = "退款订单数量")
    private int refundSize;
    @ApiModelProperty(value = "退款订单状态[退款／退货状态[-1-无状态|0-商铺发起退款|1-退款申请(用户发送退款请求)|2-退款成功(商家同意退款)|3-退款拒绝(商家拒绝退款)|4-退货申请(用户发起退货请求)|5-退货拒绝(商家拒绝退货)|6-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|7-待收货(用户已确认)|8-退货完成(商家收货并且同意退款给用户)|9-退货失败(商家不同意退款)]")
    private int refundStatus;

    private static final GoblinAppOrderDetailsVo obj = new GoblinAppOrderDetailsVo();
    public static GoblinAppOrderDetailsVo getNew() {
        try {
            return (GoblinAppOrderDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinAppOrderDetailsVo();
        }
    }
}
