package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinNftGoodsSkuListVo", description = "NFT商品SKU信息列表使用")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsSkuListVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -519573757075729441L;

    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品默认图片的URL[256]")
    private String skuPic;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "开售时间")
    private LocalDateTime saleStartTime;


    @ApiModelProperty(position = 55, value = "spu相关信息")
    private GoblinNftGoodsSpuInfoVo goblinNftGoodsSpuInfoVo;

    @ApiModelProperty(position = 56, value = "是否还有库存 0没有库存 1有库存 即售罄")
    private int isStock;

    private static final GoblinNftGoodsSkuListVo obj = new GoblinNftGoodsSkuListVo();

    public static GoblinNftGoodsSkuListVo getNew() {
        try {
            return (GoblinNftGoodsSkuListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftGoodsSkuListVo();
        }
    }

    public GoblinNftGoodsSkuListVo copy(GoblinGoodsSkuInfoVo source) {
        if (null == source) return this;
        this.setSkuId(source.getSkuId());
        this.setSpuId(source.getSpuId());
        this.setName(source.getName());
        this.setSubtitle(source.getSubtitle());
        this.setSkuPic(source.getSkuPic());
        this.setSaleStartTime(source.getSaleStartTime());
        return this;
    }
}
