package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.goblin.entity.GoblinNftOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * NFT订单表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-24
 */
@ApiModel(value = "GoblinNftOrderVo", description = "订单详情信息")
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftOrderVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -6916300673285309996L;

    @ApiModelProperty(value = "订单id")
    private String orderId;

    @ApiModelProperty(value = "商品id")
    private String spuId;

    @ApiModelProperty(value = "款式id")
    private String skuId;

    @ApiModelProperty(value = "盲盒抽取的款式id")
    private String boxSkuId;

    @ApiModelProperty(value = "数量")
    private Integer num;

    @ApiModelProperty(value = "店铺id")
    private String storeId;

    @ApiModelProperty(value = "商铺名称")
    private String storeName;

    @ApiModelProperty(value = "订单号")
    private String orderCode;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "用户昵称")
    private String userName;

    @ApiModelProperty(value = "用户手机号")
    private String userMobile;

    @ApiModelProperty(value = "应付金额")
    private BigDecimal priceTotal;

    @ApiModelProperty(value = "券优惠金额")
    private BigDecimal priceCoupon;

    @ApiModelProperty(value = "商铺券优惠金额")
    private BigDecimal storePriceCoupon;

    @ApiModelProperty(value = "红包优惠金额")
    private BigDecimal priceRedEnvelope;

    @ApiModelProperty(value = "总优惠价格")
    private BigDecimal priceVoucher;

    @ApiModelProperty(value = "实付金额")
    private BigDecimal priceActual;

    @ApiModelProperty(value = "券id")
    private String ucouponId;

    @ApiModelProperty(value = "商铺券id")
    private String storeCouponId;

    @ApiModelProperty(value = "红包code")
    private String redEnvelopeCode;

    @ApiModelProperty(value = "订单状态 1待付款 2已付款 3未付款取消订单 4退款中 5已退款")
    private Integer status;

    @ApiModelProperty(value = "订单来源 app|h5|applet")
    private String source;

    @ApiModelProperty(value = "订单类型 1购买订单 2兑换订单 3演出赠送订单")
    private Integer orderType;

    @ApiModelProperty(value = "支付类型 wepay微信 alipay阿里 douyinpay抖音 unionpay银联")
    private String payType;

    @ApiModelProperty(value = "支付终端 app wap js applet")
    private String deviceFrom;

    @ApiModelProperty(value = "版本号")
    private String version;

    @ApiModelProperty(value = "订单过期时间(分钟)")
    private Integer payCountdownMinute;

    @ApiModelProperty(value = "支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "支付单号")
    private String payCode;

    @ApiModelProperty(value = "支付中心返回实际支付类型")
    private String paymentType;

    @ApiModelProperty(value = "支付中心返回支付id")
    private String paymentId;

    @ApiModelProperty(value = "取消原因")
    private String cancelReason;

    @ApiModelProperty(value = "取消时间")
    private LocalDateTime cancelTime;

    @ApiModelProperty(value = "ip地址")
    private String ipAddress;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

    public GoblinNftOrderVo copy(GoblinNftOrder source) {
        if (null == source) return this;
        this.setOrderId(source.getOrderId());
        this.setSpuId(source.getSpuId());
        this.setSkuId(source.getSkuId());
        this.setBoxSkuId(source.getBoxSkuId());
        this.setNum(source.getNum());
        this.setStoreId(source.getStoreId());
        this.setStoreName(source.getStoreName());
        this.setOrderCode(source.getOrderCode());
        this.setUserId(source.getUserId());
        this.setUserName(source.getUserName());
        this.setUserMobile(source.getUserMobile());
        this.setPriceTotal(source.getPriceTotal());
        this.setPriceCoupon(source.getPriceCoupon());
        this.setStorePriceCoupon(source.getStorePriceCoupon());
        this.setPriceRedEnvelope(source.getPriceRedEnvelope());
        this.setPriceVoucher(source.getPriceVoucher());
        this.setPriceActual(source.getPriceActual());
        this.setUcouponId(source.getUcouponId());
        this.setStoreCouponId(source.getStoreCouponId());
        this.setRedEnvelopeCode(source.getRedEnvelopeCode());
        this.setStatus(source.getStatus());
        this.setSource(source.getSource());
        this.setOrderType(source.getOrderType());
        this.setPayType(source.getPayType());
        this.setDeviceFrom(source.getDeviceFrom());
        this.setVersion(source.getVersion());
        this.setPayCountdownMinute(source.getPayCountdownMinute());
        this.setPayCode(source.getPayCode());
        this.setIpAddress(source.getIpAddress());
        this.setCreatedAt(source.getCreatedAt());
        return this;
    }

    private static final GoblinNftOrderVo obj = new GoblinNftOrderVo();

    public static GoblinNftOrderVo getNew() {
        try {
            return (GoblinNftOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderVo();
        }
    }
}
