package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinUserDigitalArtworkInfoVo", description = "我的藏品详情")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinUserDigitalArtworkInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 8903534983251413696L;
    @ApiModelProperty(position = 11, value = "藏品名称")
    private String name;
    @ApiModelProperty(position = 12, value = "藏品副名称")
    private String subtitle;
    @ApiModelProperty(position = 13, value = "藏品素材类型[1-图片|2-视频|3-模型]")
    private String materialType;
    @ApiModelProperty(position = 14, value = "藏品素材URL")
    private String materialUrl;
    @ApiModelProperty(position = 15, value = "序列号")
    private Integer editionSn;
    @ApiModelProperty(position = 16, value = "藏品发行量")
    private Integer edition;
    @ApiModelProperty(position = 17, value = "藏品NFT ID")
    private String nftId;
//    @ApiModelProperty(position = 18, value = "NFT系列声明时间")
//    private String declareAt;

    @ApiModelProperty(position = 19, value = "获得方式[1-购买|2-兑换|3-赠送|5-受赠]")
    private Integer source;
    @ApiModelProperty(position = 20, value = "藏品状态，根据`unbox`区分盲盒来判断[0-生成中/未开启|1-已生成/已开启|2-生成失败/开启失败]")
    private Integer state;
    @ApiModelProperty(position = 21, value = "创作者")
    private String author;
    @ApiModelProperty(position = 22, value = "发行方")
    private String publisher;
    @ApiModelProperty(position = 23, value = "藏品详情")
    private String details;

    private static final GoblinUserDigitalArtworkInfoVo obj = new GoblinUserDigitalArtworkInfoVo();

    public static GoblinUserDigitalArtworkInfoVo getNew() {
        try {
            return (GoblinUserDigitalArtworkInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserDigitalArtworkInfoVo();
        }
    }

    public GoblinUserDigitalArtworkInfoVo copy(GoblinUserDigitalArtworkVo source) {
//        this.setName();
//        this.setSubtitle();
//        this.setMaterialType();
//        this.setMaterialUrl();
//        this.setEdition();
        this.setEditionSn(source.getEditionSn());
        this.setNftId(source.getNftId());
        this.setSource(source.getSource());
        this.setState(source.getState());
//        this.setAuthor();
//        this.setPublisher();
//        this.setDetails();
        return this;
    }
}
