package com.liquidnet.service.feign.kylin.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import feign.hystrix.FallbackFactory;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.HashMap;
import java.util.List;

@Component
@FeignClient(
        name = "liquidnet-service-kylin",
        contextId = "FeignKylinPerformancesClient",
        path = "",
        url = "${liquidnet.service.kylin.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignKylinPerformancesClient {

    @GetMapping("performance/{performancesId}")
    ResponseDto<KylinPerformanceVo> detail(
            @PathVariable("performancesId") String performancesId,
            @RequestParam(defaultValue = "0") double latitudeFrom,
            @RequestParam(defaultValue = "0") double longitudeFrom,
            @RequestParam(defaultValue = "0") String agentId
    );

}
