create database if not exists ln_scene character set utf8mb4 collate utf8mb4_unicode_ci;
-- >>------------------------------------------------------------------------------------
use ln_scene;

-- 积分活动表
drop TABLE if exists `sweet_integral_activity`;
CREATE TABLE `sweet_integral_activity`
(
    `mid`                  bigint unsigned NOT NULL AUTO_INCREMENT,
    `integral_activity_id` varchar(255)    NOT NULL DEFAULT '' COMMENT '活动id',
    `activity_title`       varchar(255)    NOT NULL DEFAULT '' COMMENT '活动名称',
    `activity_img`         varchar(255)    NOT NULL DEFAULT '' COMMENT '活动图片',
    `activity_type`        tinyint         NOT NULL DEFAULT 0 COMMENT '活动类型 1转盘',
    `activity_num`         int             NOT NULL DEFAULT 0 COMMENT '活动玩一次所需积分',
    `time_type`            tinyint         NOT NULL DEFAULT 0 COMMENT '活动时间类型 1长期 2开始结束时间',
    `start_time`           datetime        NULL     DEFAULT NULL COMMENT '如果活动有时间限制 开始时间',
    `end_time`             datetime        NULL     DEFAULT NULL COMMENT '如果活动有时间限制 结束时间',
    `express_fee_type`     tinyint         NOT NULL DEFAULT 0 COMMENT '快递费用类型 1包邮 2到付',
    `activity_rules`       text            NULL     DEFAULT NULL COMMENT '活动规则',
    `is_online`            tinyint         NOT NULL DEFAULT 0 COMMENT '是否上线 1未上线 2已上线',
    `created_at`           datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`           datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_integral_activity_id` (`integral_activity_id`),
    KEY `sweet_integral_activity_title` (`activity_title`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '积分活动表';

-- 积分活动奖品表
drop TABLE if exists `sweet_integral_activity_prize`;
CREATE TABLE `sweet_integral_activity_prize`
(
    `mid`                  bigint unsigned NOT NULL AUTO_INCREMENT,
    `prize_id`             varchar(255)    NOT NULL DEFAULT '' COMMENT '奖品id',
    `integral_activity_id` varchar(255)    NOT NULL DEFAULT '' COMMENT '关联活动id',
    `prize_title`          varchar(255)    NOT NULL DEFAULT '' COMMENT '奖品名称',
    `prize_img_init`       varchar(255)    NOT NULL DEFAULT '' COMMENT '初始展示奖品图片',
    `prize_img_select`     varchar(255)    NOT NULL DEFAULT '' COMMENT '中奖选中奖品图片',
    `prize_type`           tinyint         NOT NULL DEFAULT 0 COMMENT '奖品类型 1谢谢惠顾 2积分 3代金券 4满减券 5优先购买券 6实物',
    `relation_id`          varchar(255)    NOT NULL DEFAULT '' COMMENT '关联id 如商品id 券id',
    `prize_type_num`       int             NOT NULL DEFAULT 0 COMMENT '单次奖励数量如积分 中奖给多少',
    `prize_num`            int             NOT NULL DEFAULT 0 COMMENT '奖品数量',
    `winners_num`          int             NOT NULL DEFAULT 0 COMMENT '限制的中奖人数',
    `winning_probability`  decimal(10, 2)  NOT NULL DEFAULT 0 COMMENT '中奖概率',
    `created_at`           datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`           datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_prize_id` (`prize_id`),
    KEY `sweet_prize_integral_activity_id` (`integral_activity_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '积分活动奖品表';

-- 积分活动抽奖记录表
drop TABLE if exists `sweet_integral_activity_draw`;
CREATE TABLE `sweet_integral_activity_draw`
(
    `mid`                    bigint unsigned NOT NULL AUTO_INCREMENT,
    `draw_id`                varchar(255)    NOT NULL DEFAULT '' COMMENT '抽奖id',
    `integral_activity_id`   varchar(255)    NOT NULL DEFAULT '' COMMENT '关联活动id',
    `activity_num`           int             NOT NULL DEFAULT 0 COMMENT '活动玩一次所需积分',
    `prize_id`               varchar(255)    NOT NULL DEFAULT '' COMMENT '关联奖品id',
    `prize_title`            varchar(255)    NOT NULL DEFAULT '' COMMENT '奖品名称',
    `prize_type`             tinyint         NOT NULL DEFAULT 0 COMMENT '奖品类型 1谢谢惠顾 2积分 3代金券 4满减券 5优先购买券 6实物',
    `prize_type_num`         int             NOT NULL DEFAULT 0 COMMENT '单次奖励数量如积分 中奖给多少',
    `relation_id`            varchar(255)    NOT NULL DEFAULT '' COMMENT '关联id 如商品id 券id',
    `user_id`                varchar(255)    NOT NULL DEFAULT '' COMMENT '关联用户id',
    `nickname`               varchar(255)    NOT NULL DEFAULT '' COMMENT '关联用户昵称',
    `receiving_addresses_id` varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货地址addresses_id',
    `receiving_name`         varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人姓名',
    `receiving_phone`        varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人手机号',
    `receiving_address`      varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人完整地址 空格隔离省市区详细地址',
    `receiving_status`       smallint        NOT NULL DEFAULT 1 COMMENT '发放状态 1未发放 2已发放 3无需发放',
    `created_at`             datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`             datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_draw_id` (`draw_id`),
    KEY `sweet_draw_integral_activity_id` (`integral_activity_id`),
    KEY `sweet_draw_prize_id` (`prize_id`),
    KEY `sweet_draw_user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '积分活动抽奖记录表';

-- 微信用户信息表包含小程序公众号
drop TABLE if exists `sweet_wechat_users`;
CREATE TABLE `sweet_wechat_users`
(
    `mid`               bigint unsigned NOT NULL AUTO_INCREMENT,
    `wechat_id`         varchar(200)    NOT NULL DEFAULT '' COMMENT 'wechat_id',
    `open_id`           varchar(200)    NOT NULL DEFAULT '' COMMENT 'openId',
    `union_id`          varchar(200)    NOT NULL DEFAULT '' COMMENT 'unionId',
    `type`              tinyint         NOT NULL DEFAULT 0 COMMENT '服务类型 1正在 2摩登 21草莓 22五百里 23mdsk 24正在',
    `phone_number`      varchar(200)    NOT NULL DEFAULT '' COMMENT '小程序解密手机号',
    `pure_phone_number` varchar(200)    NOT NULL DEFAULT '' COMMENT '小程序解密手机号',
    `country_code`      varchar(200)    NOT NULL DEFAULT '' COMMENT '小程序解密地区码',
    `nickname`          varchar(200)    NOT NULL DEFAULT '' COMMENT '昵称',
    `sex_desc`          varchar(200)    NOT NULL DEFAULT '' COMMENT '性别',
    `sex`               tinyint         NOT NULL DEFAULT 0 COMMENT '性别 男1',
    `head_img_url`      varchar(200)    NOT NULL DEFAULT '' COMMENT '头像',
    `language`          varchar(200)    NOT NULL DEFAULT '' COMMENT 'zh_CN',
    `country`           varchar(200)    NOT NULL DEFAULT '' COMMENT '国家',
    `province`          varchar(200)    NOT NULL DEFAULT '' COMMENT '省',
    `city`              varchar(200)    NOT NULL DEFAULT '' COMMENT '市',
    `subscribe_time`    datetime        NULL     DEFAULT null COMMENT '关注时间',
    `subscribe_scene`   varchar(200)    NOT NULL DEFAULT '' COMMENT 'ADD_SCENE_SEARCH 关注方式',
    `created_at`        datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`        datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `idx_sweet_wechat_id` (`wechat_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '微信用户信息表包含小程序公众号';

-- 微信用户信息关联表
drop TABLE if exists `sweet_wechat_users_relation`;
CREATE TABLE `sweet_wechat_users_relation`
(
    `mid`                bigint unsigned NOT NULL AUTO_INCREMENT,
    `wechat_relation_id` varchar(200)    NOT NULL DEFAULT '' COMMENT 'wechat_relation_id',
    `union_id`           varchar(200)    NOT NULL DEFAULT '' COMMENT 'unionId',
    `user_id`            varchar(200)    NOT NULL DEFAULT '' COMMENT 'adam用户id',
    `user_phone`         varchar(200)    NOT NULL DEFAULT '' COMMENT 'adam用户手机号',
    `created_at`         datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`         datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `idx_sweet_wechat_relation_id` (`wechat_relation_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '微信用户信息关联表';