package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.text.Convert;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.goblin.dto.GoblinSelfExtagExcelDto;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinSelfGoodsCategoryService;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinSelfTagService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.entity.GoblinSelfTag;
import com.liquidnet.service.goblin.entity.GoblinStoreCertification;
import com.liquidnet.service.goblin.entity.GoblinStoreInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@Api(tags = "标签库")
@Controller
@RequestMapping("goblin/tag")
public class GoblinSelfTagController extends BaseController {
    private final String prefix = "zhengzai/goblin/tag";
    @Autowired
    IGoblinSelfTagService goblinSelfTagService;

    @GetMapping("")
    public String tag() {
        return prefix.concat("/tag");
    }

    @RequiresPermissions("goblin:tag:list")
    @RequestMapping("list")
    @ResponseBody
    public TableDataInfo list(GoblinSelfTag selfTag) {
        startPage();
        return getDataTable(listQuery(selfTag));
    }

    private List<GoblinSelfTag> listQuery(GoblinSelfTag selfTag) {
        LambdaQueryWrapper<GoblinSelfTag> lambdaQueryWrapper = Wrappers.lambdaQuery(GoblinSelfTag.class);
        lambdaQueryWrapper.eq(GoblinSelfTag::getDelFlg, "0");
        lambdaQueryWrapper.eq(GoblinSelfTag::getTagBelong, "0");
        if (StringUtils.isNotBlank(selfTag.getTagName())) {
            lambdaQueryWrapper.like(GoblinSelfTag::getTagName, selfTag.getTagName());
        }
        if (StringUtils.isNotBlank(selfTag.getTagType())) {
            lambdaQueryWrapper.eq(GoblinSelfTag::getTagType, selfTag.getTagType());
        }

        lambdaQueryWrapper.select(
                GoblinSelfTag::getTagId,
                GoblinSelfTag::getTagName,
                GoblinSelfTag::getTagPic,
                GoblinSelfTag::getTagType,
                GoblinSelfTag::getCounts
        );
        return goblinSelfTagService.list(lambdaQueryWrapper);
    }

//    @RequiresPermissions("goblin:tag:export")
//    @Log(title = "店铺管理:标签库:导出", businessType = BusinessType.EXPORT)
//    @PostMapping("export")
//    @ResponseBody
//    public AjaxResult export(GoblinSelfTag selfTag) {
//        List<GoblinSelfTag> list = listQuery(selfTag);
//        ExcelUtil<GoblinSelfExtagExcelDto> excelUtil = new ExcelUtil<>(GoblinSelfExtagExcelDto.class);
//        List<GoblinSelfExtagExcelDto> excelList = new ArrayList<>();
//        list.forEach(r -> excelList.add(GoblinSelfExtagExcelDto.getNew().copy(r)));
//        return excelUtil.exportExcel(excelList, "音乐人标签库");
//    }

    @ApiOperation(value = "新建")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tagName", value = "标签名称[50]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tagPic", value = "标签图片[256]"),
    })
    @Log(title = "店铺管理:标签库:新建", businessType = BusinessType.INSERT)
    @RequiresPermissions("goblin:tag:add")
    @PostMapping("addSave")
    @ResponseBody
    public AjaxResult addSave(String tagName, String tagPic) {
        GoblinSelfTag selfTag = new GoblinSelfTag();

        selfTag.setTagId(IDGenerator.nextMilliId2());
        selfTag.setTagName(tagName);
        selfTag.setTagPic(tagPic);
        selfTag.setTagType("0");
        selfTag.setTagBelong("0");

        return toAjax(goblinSelfTagService.save(selfTag));
    }

    @ApiOperation(value = "编辑")
    @Log(title = "店铺管理:标签库:编辑", businessType = BusinessType.UPDATE)
    @RequiresPermissions("goblin:tag:edit")
    @PostMapping("editSave")
    @ResponseBody
    public AjaxResult editSave(GoblinSelfTag selfTag) {
        // TODO: 2022/1/13 zhanggb valid
        LambdaUpdateWrapper<GoblinSelfTag> updateWrapper = Wrappers.lambdaUpdate(GoblinSelfTag.class);
        updateWrapper.eq(GoblinSelfTag::getTagId, selfTag.getTagId());
        updateWrapper.eq(GoblinSelfTag::getTagBelong, "1");

        updateWrapper.set(GoblinSelfTag::getTagType, selfTag.getTagType());
        updateWrapper.set(GoblinSelfTag::getTagName, selfTag.getTagName());
        updateWrapper.set(GoblinSelfTag::getTagPic, selfTag.getTagPic());
        return toAjax(goblinSelfTagService.update(updateWrapper));
    }

    @Log(title = "店铺管理:标签库:删除", businessType = BusinessType.DELETE)
    @RequiresPermissions("goblin:tag:rmv")
    @PostMapping("rmv")
    @ResponseBody
    public AjaxResult rmv(String tagIds) {
        return toAjax(goblinSelfTagService.update(Wrappers.lambdaUpdate(GoblinSelfTag.class)
                .in(GoblinSelfTag::getTagId, Convert.toStrArray(tagIds))
                .set(GoblinSelfTag::getDelFlg, "1")
        ));
    }
}
