package com.liquidnet.service.sweet.service.impl.five;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualFiveDto;
import com.liquidnet.service.sweet.entity.SweetManualFive;
import com.liquidnet.service.sweet.mapper.SweetManualFiveMapper;
import com.liquidnet.service.sweet.service.five.ISweetManualFiveService;
import com.liquidnet.service.sweet.utils.RedisFiveDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 电子宣传手册表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualFiveServiceImpl extends ServiceImpl<SweetManualFiveMapper, SweetManualFive> implements ISweetManualFiveService {

    @Autowired
    private SweetManualFiveMapper sweetManualFiveMapper;
    @Autowired
    private RedisFiveDataUtils redisDataUtils;

    @Override
    public ResponseDto<PageInfo<SweetManualFiveDto>> getManualList(int page, int size, String name) {
        PageInfo<SweetManualFiveDto> pageInfoTmp;
        try {
            PageHelper.startPage(page, size);
            HashMap<String, Object> map = CollectionUtil.mapStringObject();
            map.put("title", name);
            List<SweetManualFiveDto> voList = sweetManualFiveMapper.getManualList(map);
            for (int i = 0; i < voList.size(); i++) {
                SweetManualFiveDto vo = voList.get(i);
                if (vo.getStatus() >= 6 && vo.getStatus() != 7) {
                    if (DateUtil.compareStrDay(vo.getTimeSell(), DateUtil.getNowTime()) > 0) {//未开始
                        vo.setStatus(9);
                    } else if (DateUtil.compareStrDay(vo.getTimeStop(), DateUtil.getNowTime()) < 0) {//已结束
                        vo.setStatus(10);
                    } else {
                        vo.setStatus(6);
                    }
                }
            }
            pageInfoTmp = new PageInfo(voList);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure(ErrorMapping.get(20104));
        }
        return ResponseDto.success(pageInfoTmp);
    }

    @Override
    public ResponseDto<SweetManualFiveDto> details(String manualId) {
        SweetManualFiveDto vo;
        try {
            HashMap<String, Object> map = CollectionUtil.mapStringObject();
            map.put("manualId", manualId);
            vo = sweetManualFiveMapper.getManualDetails(map);
            if (vo.getStatus() >= 6 && vo.getStatus() != 7) {
                if (DateUtil.compareStrDay(vo.getTimeSell(), DateUtil.getNowTime()) > 0) {//未开始
                    vo.setStatus(9);
                } else if (DateUtil.compareStrDay(vo.getTimeStop(), DateUtil.getNowTime()) < 0) {//已结束
                    vo.setStatus(10);
                } else {
                    vo.setStatus(6);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure(ErrorMapping.get(20104));
        }
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<Boolean> changeStatus(String manualId, String performancesId, Integer status) {
        try {
            int count = sweetManualFiveMapper.selectCount(Wrappers.lambdaUpdate(SweetManualFive.class).eq(SweetManualFive::getManualId, manualId));
            SweetManualFive sweetManual = SweetManualFive.getNew();
            if (count > 0) {//修改
                sweetManual.setStatus(status);
                sweetManual.setUpdatedAt(LocalDateTime.now());
                sweetManualFiveMapper.update(sweetManual, Wrappers.lambdaUpdate(SweetManualFive.class).eq(SweetManualFive::getManualId, manualId));
            } else {//创建
                sweetManual.setManualId(IDGenerator.nextSnowId());
                sweetManual.setPerformanceId(performancesId);
                sweetManual.setStatus(status);
                sweetManual.setIsRelease(0);
                sweetManual.setCreatedAt(LocalDateTime.now());
                sweetManualFiveMapper.insert(sweetManual);
            }
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        redisDataUtils.deletePushListRedisData();
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeRelease(String manualId, Integer isRelease) {
        try {
            SweetManualFive sweetManual = SweetManualFive.getNew();
            sweetManual.setIsRelease(isRelease);
            sweetManual.setUpdatedAt(LocalDateTime.now());
            sweetManualFiveMapper.update(sweetManual, Wrappers.lambdaUpdate(SweetManualFive.class).eq(SweetManualFive::getManualId, manualId));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        redisDataUtils.deletePushListRedisData();
        return ResponseDto.success();
    }

}
