package com.liquidnet.service.chime.utils;

import com.liquidnet.service.feign.adam.api.FeignAdamBaseClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class QueueUtils {

//    @Autowired
//    private RabbitTemplate rabbitTemplate;
//    @Autowired
//    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private FeignAdamBaseClient feignAdamBaseClient;

    /**
     * 发送消息 - RABBIT
     *
     * @param exchange 交换机
     * @param routeKey 路径
     * @param jsonMsg  Json字符串
     */
//    public void sendMsgByRabbit(String exchange, String routeKey, String jsonMsg) {
//        rabbitTemplate.convertAndSend(exchange, routeKey, jsonMsg);
//    }

    /**
     * 发送消息 - REDIS
     *
     * @param streamKey Redis消费Key
     * @param jsonMsg   Json字符串
     */
    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        try {
            feignAdamBaseClient.sendMsgToRedis(streamKey,jsonMsg);
        } catch (Exception e) {
            log.error("userOperation sendMsgByRedis error:{}",e);
            log.error("userOperation sendMsgByRedis error msg",e.getMessage());
            e.printStackTrace();
        }
    }
//    public void sendMsgByRedis(String streamKey, String jsonMsg) {
//        HashMap<String, String> map = CollectionUtil.mapStringString();
//        map.put(MQConst.QUEUE_MESSAGE_KEY, jsonMsg);
//        try {
//            stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
//        } catch (Exception e) {
//            log.error("userLikeOperation error:{}",e);
//            log.error("userLikeOperation error msg",e.getMessage());
//            e.printStackTrace();
//        }
//    }
}
