package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 发行+购买结果查询
 * @class: GalaxyNftPublishResultQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/28 11:22
 */
@ApiModel(value = "GalaxyNftPublishResultQueryRespDto", description = "NFT发行结果查询")
@Data
public class GalaxyNftPublishAndBuyResultBatchQueryRespDto implements Serializable,Cloneable {

    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    private String userId;

    @ApiModelProperty(position = 1, required = true, value = "用户购买信息List")
    private List<BuyInfo> buyInfoList;


    @Override
    public String toString() {
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishAndBuyResultBatchQueryRespDto obj = new GalaxyNftPublishAndBuyResultBatchQueryRespDto();

    public static GalaxyNftPublishAndBuyResultBatchQueryRespDto getNew() {
        try {
            return (GalaxyNftPublishAndBuyResultBatchQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishAndBuyResultBatchQueryRespDto();
        }
    }

    @Data
    public static class BuyInfo{
        @ApiModelProperty(position = 2, required = true, value = "nft订单唯一id")
        private String nftOrderPayId;

        @ApiModelProperty(position = 2, required = true, value = "nftId")
        private String nftId;

        @ApiModelProperty(position = 3, required = true, value = "nft发行时间")
        private String nftPublishChainTimestamp;

        @ApiModelProperty(position = 4, required = true, value = "nft发行状态")
        private String nftPublishStatus;

        @ApiModelProperty(position = 5, required = true, value = "nft发行交易hash")
        private String nftPublishTxHash;

        @ApiModelProperty(position = 6, required = true, value = "nft购买时间")
        private String nftBuyChainTimestamp;

        @ApiModelProperty(position = 7, required = true, value = "nft购买状态")
        private String nftBuyStatus;

        @ApiModelProperty(position = 8, required = true, value = "nft购买交易hash")
        private String nftBuyTxHash;
    }
}
