package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinCommonBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/30 17:51
 */
@Slf4j
@Component
public class ZxinCommonBiz {
    @Autowired
    private ZxlnftConfig zxlnftConfig;

    public GalaxyNftOrderBo buildNftOrderBo(String nftOrderPayId,GalaxyUserInfoBo userInfoBo, GalaxySeriesNftInfoBo seriesNftInfoBo){
        GalaxyNftOrderBo nftOrderBo = GalaxyNftOrderBo.getNew();
        nftOrderBo.setUserId(userInfoBo.getUserId());
        nftOrderBo.setSkuId(seriesNftInfoBo.getSkuId());
        nftOrderBo.setSeriesName(seriesNftInfoBo.getSeriesName());
        nftOrderBo.setSeriesId(seriesNftInfoBo.getSeriesId());
        nftOrderBo.setSeriesCode(seriesNftInfoBo.getSeriesCode());
        nftOrderBo.setNftOrderPayId(nftOrderPayId);
        nftOrderBo.setNftId(null);
        nftOrderBo.setNftPrice(seriesNftInfoBo.getSellCount().longValue());
        nftOrderBo.setNftPublishTaskId(null);
        nftOrderBo.setNftPublishFromAddress(zxlnftConfig.getNftPlatformAddress());
        nftOrderBo.setNftPublishToAddress("NFT");
        nftOrderBo.setNftPublishChainTimestamp(null);
        nftOrderBo.setNftPublishStatus(null);
        nftOrderBo.setNftPublishTradeHash(null);
        nftOrderBo.setNftBuyTaskId(null);
        nftOrderBo.setNftBuyFromAddress(zxlnftConfig.getNftPlatformAddress());
        nftOrderBo.setNftBuyToAddress(userInfoBo.getBlockChainAddress());
        nftOrderBo.setNftBuyChainTimestamp(null);
        nftOrderBo.setNftBuyStatus(null);
        nftOrderBo.setNftBuyTradeHash(null);
        nftOrderBo.setNftBuyPayTaskId(null);
        nftOrderBo.setRouterType(seriesNftInfoBo.getRouterType());
        nftOrderBo.setCreatedAt(LocalDateTime.now());
        nftOrderBo.setUpdatedAt(null);
        return nftOrderBo;
    }
}
