package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberOrderPreviewVo", description = "会员订单预览")
@Data
public class AdamMemberOrderPreviewVo implements Serializable {
    private static final long serialVersionUID = 2035177741044060344L;
    @ApiModelProperty(position = 10, value = "会员ID[50]")
    private String memberId;
    @ApiModelProperty(position = 11, value = "会员标题[50]", example = "摩登天空会员")
    private String memberTitle;
    @ApiModelProperty(position = 12, value = "价格详情")
    private AdamMemberPriceVo priceVo;
    @ApiModelProperty(position = 13, value = "实名信息")
    private AdamRealInfoVo realInfoVo;
    @ApiModelProperty(position = 14, value = "生日")
    private String birthday;
    @ApiModelProperty(position = 15, value = "常住地/区域[100]", example = "北京 北京市 朝阳区")
    private String area;

    private static final AdamMemberOrderPreviewVo obj = new AdamMemberOrderPreviewVo();

    public static AdamMemberOrderPreviewVo getNew() {
        try {
            return (AdamMemberOrderPreviewVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderPreviewVo();
        }
    }
}
