package com.liquidnet.service.kylin.dto.param;

import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesTicketCreatePartnerVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class PerformanceStep2Param implements Serializable,Cloneable {

    @ApiModelProperty(value = "演出id", example = "")
    @NotNull(message = "不能为空")
    private String performancesId;

    @ApiModelProperty(value = "是否实名", example = "0")
    @NotNull(message = "不能为空")
    private Integer isTrueName;

    @ApiModelProperty(value = "限购数量 0为不限购", example = "0")
    @NotNull(message = "不能为空")
    private Integer limitCount;

    @ApiModelProperty(value = "实名限购 0为不限购", example = "0")
    @NotNull(message = "不能为空")
    private Integer idCount;

    @ApiModelProperty(value = "开票提醒 0为不提醒", example = "0")
    @NotNull(message = "不能为空")
    private Integer isInvoiceReminder;

    @ApiModelProperty(value = "是否提交 1提交 0不提交(不验证参数)", example = "0")
    @NotNull(message = "不能为空")
    private Integer isSubmit;

    @ApiModelProperty(hidden = true)
    private Integer auditStatus;

    @ApiModelProperty(hidden = true)
    private Integer status;

    @ApiModelProperty(hidden = true)
    private String merchantId;

    @ApiModelProperty(value = "场次数据",hidden = true)
    private List<TicketTimesTicketCreatePartnerVo> ticketTimes;

    private static final PerformanceStep2Param obj = new PerformanceStep2Param();
    public static PerformanceStep2Param getNew() {
        try {
            return (PerformanceStep2Param) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new PerformanceStep2Param();
        }
    }
}
