package com.liquidnet.service.erp.config;


import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.MD5Utils;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.util.*;

@Component
@Slf4j
public class ErpWdtClient {

    @Value("${liquidnet.erp.wdt.api.appKey}")
    private String appkey;
    @Value("${liquidnet.erp.wdt.api.sid}")
    private String sid;
    @Value("${liquidnet.erp.wdt.api.appsecret}")
    private String appSecret;
    @Value("${liquidnet.erp.wdt.url}")
    private String baseUrl;

    /**
     * 获取 erp的sign
     *
     * @param map       请求参数
     * @param appSecret 秘钥
     * @return
     */
    private String getErpSign(Map<String, String> map, String appSecret) {
        String finalStr = "";
        map = sortMapByKey(map);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String key01 = leftFillChar(key, "0", 2).concat("-").concat(key);
            String value01 = leftFillChar(value, "0", 4).concat("-").concat(value);
            String data = key01.concat(":").concat(value01).concat(";");
            finalStr = finalStr.concat(data);
        }
        finalStr = finalStr.substring(0, finalStr.length() - 1).concat(appSecret);
        return MD5Utils.md5(finalStr);
    }

    // 根据key 排序 hash
    private HashMap<String, String> sortMapByKey(Map<String, String> map) {
        LinkedHashMap<String, String> finalMap = CollectionUtil.linkMapStringString();
        List<String> ll = new ArrayList<>(map.keySet());
        Collections.sort(ll);
        for (String str : ll) {
            finalMap.put(str, map.get(str));
        }
        return finalMap;
    }

    // sign补位算法
    private String leftFillChar(String str, String charStr, int a) {
        String length = str.length() + "";
        for (int i = length.length(); i < a; i++) {
            length = charStr.concat(length);
        }
        return length;
    }

    public String execute(String url, Map<String, String> param) {
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
        param.put("appkey", this.appkey);
        param.put("sid", this.sid);
        param.put("timestamp", Long.toString(System.currentTimeMillis() / 1000));
        param.put("sign", getErpSign(param, appSecret));
        params.setAll(param);
        String returnData = HttpUtil.post(baseUrl.concat(url), params, header);
        return returnData;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appkey", "test2-xx");
        map.put("page_no", "0");
        map.put("end_time", "2016-08-01 13:00:00");
        map.put("start_time", "2016-08-01 12:00:00");
        map.put("page_size", "40");
        map.put("sid", "test2");
        map.put("timestamp", "1470042310");
    }

}
