package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.vo.TempBannerVo;
import com.liquidnet.service.sweet.param.SweetCityVoteParam;
import com.liquidnet.service.sweet.param.TempBannerParam;
import com.liquidnet.service.sweet.service.ISweetCityVoteService;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetCItyVoteStatVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.auth.In;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 城市投票表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-15
 */
@Api(tags = "活动-城市投票")
@RestController
@RequestMapping("/sweetCityVote")
public class SweetCityVoteController {

    @Autowired
    private ISweetCityVoteService sweetCityVoteService;

    @GetMapping("statList")
    @ApiOperation("城市投票排名列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "phone", value = "手机号", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "unionId", value = "unionId", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "活动类型 1新裤子 2莫宰羊", required = false)
    })
    public ResponseDto<List<SweetCItyVoteStatVo>> getList(
            @RequestParam String phone,
            @RequestParam String unionId,
            @RequestParam(defaultValue = "1") Integer type
    ) {
        return sweetCityVoteService.getList(phone, unionId, type);
    }

    @PostMapping("createVote")
    @ApiOperation("用户投票")
    public ResponseDto createVote(@Valid @RequestBody SweetCityVoteParam param) {
        return sweetCityVoteService.createVote(param);
    }

    @GetMapping("setStatList")
    @ApiOperation("统计投票排名")
    public ResponseDto setStatList(@RequestParam Integer type) {
        return sweetCityVoteService.setStatList(type);
    }


    @Autowired
    RedisDataUtils redisDataUtils;

    @PostMapping("setTime")
    @ApiOperation("临时-设置时间")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "endTime", value = "结束时间[2021-12-01 10:00:00]", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "startTime", value = "开始时间[2021-12-01 10:00:00]", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "活动类型 1新裤子 2莫宰羊", required = false)
    })
    public void setStartEndTime(@RequestParam Integer type, @RequestParam String startTime, @RequestParam String endTime) {
        redisDataUtils.setStartEndTime(type, startTime, endTime);
    }

    @PostMapping("setBanner")
    @ApiOperation("临时-设置banner")
    public void setTempBanner(@RequestBody TempBannerParam param) {
        redisDataUtils.setTempBanner(param.getType(), param.getTempBannerVo());
    }
}
