create table galaxy_user_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    user_id varchar(200)  NOT NULL COMMENT '用户ID',
    user_name varchar(200)  NOT NULL COMMENT '用户姓名',
    user_type varchar(3)  NOT NULL DEFAULT '2' COMMENT '1企业 2个人',
    mobile varchar(20) COMMENT '移动手机号',
    id_card_type varchar(3)  NOT NULL COMMENT '证件类型( 1-身份证 2-护照 3-港澳通行证 4-台湾通行证 5-外国人永居身份证 6-港澳台居民居住证 7-其它)',
    id_card varchar(50)  NOT NULL COMMENT '证件号码',
    mnemonic varchar(200)  COMMENT '助记词',
    mnemonic_index varchar(3)  NOT NULL DEFAULT '0' COMMENT '助记词索引',
    user_identification varchar(200) COMMENT '用户链上唯一ID',
    user_pub_key varchar(500) COMMENT '用户公钥',
    user_pri_key varchar(500) COMMENT '用户私钥',
    block_chain_address varchar(200) COMMENT '区块链地址',
    router_type varchar(200)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
) ENGINE = InnoDB comment '数字藏品用户信息';

create table galaxy_series_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    series_info_id varchar(100) NOT NULL COMMENT '系列存储ID',
    series_name varchar(28) NOT NULL COMMENT '本地系列唯一名称(前缀+skuid)',
    series_code varchar(200) NOT NULL COMMENT '系列编码',
    series_id varchar(200) COMMENT '区块链上系列ID',
    total_count varchar(50)   COMMENT '系列发行总量',
    crt_count varchar(200)   COMMENT '系列已发行个数',
    series_claim_task_id varchar(200)   COMMENT '系列声明任务ID',
    series_claim_status varchar(200)   COMMENT '系列声明状态',
    cover_url varchar(1000)   COMMENT '系列显示封面',
    series_desc varchar(200)   COMMENT '系列描述信息，不超过500个字符',
    chain_timestamp varchar(30)   COMMENT '系列链上声明时间',
    trade_hash varchar(100)   COMMENT '系列链上交易hash',
    nft_count int default 0 COMMENT '系列中包含nft个数',
    router_type varchar(200)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品系列信息';

create table galaxy_series_nft_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    series_nft_info_id varchar(100) NOT NULL COMMENT '系列nft存储ID',
    series_info_id varchar(100) NOT NULL COMMENT '系列存储ID',
    sku_id varchar(200)  NOT NULL  COMMENT '本地系列nft唯一标识id',
    series_name varchar(28) NOT NULL COMMENT '本地系列唯一名称(前缀+skuid)',
    series_code varchar(200) NOT NULL COMMENT '本地系列唯一编码',
    series_id varchar(200) COMMENT '区块链上系列ID',
    nft_total_count varchar(50)   COMMENT '系列nft发行总量',
    nft_crt_count varchar(200)   COMMENT '系列nft已发行个数',
    nft_id_begin varchar(200) COMMENT '系列nft发行开始id',
    original_nft_url varchar(1000)   COMMENT 'nft素材原始地址',
    original_display_url varchar(1000)   COMMENT 'nft显示素材原始地址',
    author varchar(200)   COMMENT '作者名',
    nft_name varchar(200)   COMMENT 'nft名字(sku名称)',
    nft_url varchar(1000)   COMMENT 'nft素材地址',
    display_url varchar(1000)   COMMENT '预览图url，不超过1024个字符',
    nft_desc varchar(400)   COMMENT 'nft简介，500个字符以内',
    nft_flag varchar(200)   COMMENT '标签，【文创】，游戏，动漫，30个字符以内',
    sell_count varchar(200)   COMMENT '可售状态下有意义',
    nft_hash varchar(200) COMMENT ' 系列声明中nftHash',
    router_type varchar(200)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品系列nft信息';

create table galaxy_nft_order_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    nft_order_pay_id varchar(20)   COMMENT '订单支付唯一ID',
    user_id varchar(200)  NOT NULL COMMENT '用户ID',
    sku_id varchar(200)  NOT NULL  COMMENT '应用系统购买系列唯一ID',
    series_name varchar(20) NOT NULL COMMENT '系列的唯一名称(前缀+skuid)',
    series_id varchar(3) COMMENT '系列的唯一Id',
    nft_id varchar(200)   COMMENT 'nftId',
    nft_price varchar(50)   COMMENT 'nft购买价格',
    nft_publish_task_id varchar(100)   COMMENT 'nft发行任务id',
    nft_publish_from_address varchar(200)   COMMENT 'nft发行转出方地址',
    nft_publish_to_address varchar(200)   COMMENT 'nft发行转入方地址',
    nft_publish_chain_timestamp varchar(30)   COMMENT 'nft发行时间',
    nft_publish_status varchar(30)   COMMENT 'nft发行状态',
    nft_publish_trade_hash varchar(100)   COMMENT 'nft发行交易hash',
    nft_buy_task_id varchar(100)   COMMENT 'nft购买任务id',
    nft_buy_from_address varchar(200)   COMMENT 'nft购买转出方地址',
    nft_buy_to_address varchar(200)   COMMENT 'nft购买转入方地址',
    nft_buy_chain_timestamp varchar(30)   COMMENT 'nft购买时间',
    nft_buy_status varchar(30)   COMMENT 'nft购买状态',
    nft_buy_trade_hash varchar(100)   COMMENT 'nft购买交易hash',
    nft_buy_pay_task_id varchar(100)   COMMENT 'nft购买支付任务id',
    router_type varchar(20)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品订单信息';

create table galaxy_nft_trade_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    nft_id varchar(200)   COMMENT 'nftId',
    series_id varchar(3) COMMENT '系列的唯一Id',
    trade_hash varchar(200)   COMMENT '交易hash',
    chain_timestamp varchar(20)   COMMENT '链上交易时间戳',
    from_address varchar(200)   COMMENT '转出方地址',
    to_address varchar(200)   COMMENT '转入方地址',
    trade_price bigint COMMENT '交易价格',
    trade_type varchar(3)   COMMENT '交易类别 1发行 2购买 3转移 4设置价格 5设置状态',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
) ENGINE = InnoDB comment '数字藏品交易信息';